/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.stream.Collectors;

public class ResourceLoader {
    public static final ResourceLoader DEFAULT = new ResourceLoader("/");
    private final String rootPath;

    public ResourceLoader(String rootPath) {
        this.rootPath = Objects.requireNonNull(rootPath, "rootPath cannot be null");
    }

    public String toString(String relPath) {
        String absPath = this.rootPath + relPath;
        InputStream is = this.getClass().getResourceAsStream(absPath);
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return null;
    }
}

