/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.nio.ByteBuffer;

class SchemaRegistryProtocol {
    public static final short SR_PROTOCOL_V0 = 0;

    SchemaRegistryProtocol() {
    }

    public static ByteBuffer serializeMetadata(SchemaRegistryIdentity identity) {
        return identity.toJsonBytes();
    }

    public static SchemaRegistryIdentity deserializeMetadata(ByteBuffer buffer) {
        return SchemaRegistryIdentity.fromJson(buffer);
    }

    public static ByteBuffer serializeAssignment(Assignment assignment) {
        return assignment.toJsonBytes();
    }

    public static Assignment deserializeAssignment(ByteBuffer buffer) {
        return Assignment.fromJson(buffer);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Assignment {
        public static final int CURRENT_VERSION = 1;
        public static final short NO_ERROR = 0;
        public static final short DUPLICATE_URLS = 1;
        private final int version;
        private final short error;
        private final String leader;
        private final SchemaRegistryIdentity leaderIdentity;

        public Assignment(@JsonProperty(value="error") short error, @JsonProperty(value="master") String leader, @JsonProperty(value="master_identity") SchemaRegistryIdentity leaderIdentity) {
            this.version = 1;
            this.error = error;
            this.leader = leader;
            this.leaderIdentity = leaderIdentity;
        }

        public static Assignment fromJson(ByteBuffer json) {
            try {
                byte[] jsonBytes = new byte[json.remaining()];
                json.get(jsonBytes);
                return (Assignment)JacksonMapper.INSTANCE.readValue(jsonBytes, Assignment.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error deserializing identity information", e);
            }
        }

        @JsonProperty(value="version")
        public int version() {
            return this.version;
        }

        @JsonProperty(value="error")
        public short error() {
            return this.error;
        }

        @JsonProperty(value="master")
        public String leader() {
            return this.leader;
        }

        @JsonProperty(value="master_identity")
        public SchemaRegistryIdentity leaderIdentity() {
            return this.leaderIdentity;
        }

        public boolean failed() {
            return this.error != 0;
        }

        public ByteBuffer toJsonBytes() {
            try {
                return ByteBuffer.wrap(JacksonMapper.INSTANCE.writeValueAsBytes((Object)this));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error serializing identity information", e);
            }
        }

        public String toString() {
            return "Assignment{version=" + this.version + ", error=" + this.error + ", leader='" + this.leader + '\'' + ", leaderIdentity=" + this.leaderIdentity + '}';
        }
    }
}

