/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryCoordinator;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryProtocol;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryRebalanceListener;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SchemaRegistryCoordinatorTest {
    private static final String LEADER_ID = "leader";
    private static final String MEMBER_ID = "member";
    private static final String LEADER_HOST = "leaderHost";
    private static final int LEADER_PORT = 8083;
    private static final String MEMBER_0 = "member-0";
    private static final String MEMBER_0_HOST = "member-0-host";
    private static final String MEMBER_1 = "member-1";
    private static final String MEMBER_1_HOST = "member-1-host";
    private static final String MEMBER_2 = "member-2";
    private static final String MEMBER_2_HOST = "member-2-host";
    private static final SchemaRegistryIdentity LEADER_INFO = new SchemaRegistryIdentity("leaderHost", Integer.valueOf(8083), Boolean.valueOf(true), "http");
    private static final SchemaRegistryIdentity INELIGIBLE_LEADER_INFO = new SchemaRegistryIdentity("leaderHost", Integer.valueOf(8083), Boolean.valueOf(false), "http");
    private static final SchemaRegistryIdentity MEMBER_0_INFO = new SchemaRegistryIdentity("member-0-host", Integer.valueOf(8083), Boolean.valueOf(true), "https");
    private static final SchemaRegistryIdentity MEMBER_1_INFO = new SchemaRegistryIdentity("member-1-host", Integer.valueOf(8083), Boolean.valueOf(true), "https");
    private static final SchemaRegistryIdentity MEMBER_2_INFO = new SchemaRegistryIdentity("member-2-host", Integer.valueOf(8083), Boolean.valueOf(true), "https");
    private MockTime time;
    private MockClient client;
    private final Cluster cluster = TestUtils.clusterWith((int)3, (String)"topic", (int)3);
    private final Node node = (Node)this.cluster.nodes().get(0);
    private Metrics metrics;
    private MockRebalanceListener rebalanceListener;
    private MockRebalanceListener member0RebalanceListener;
    private MockRebalanceListener member1RebalanceListener;
    private MockRebalanceListener member2RebalanceListener;
    private SchemaRegistryCoordinator coordinator;
    private SchemaRegistryCoordinator member0Coordinator;
    private SchemaRegistryCoordinator member1Coordinator;
    private SchemaRegistryCoordinator member2Coordinator;
    private LogContext logContext;
    private ConsumerNetworkClient consumerClient;
    private final String groupId = "test-group";
    private final int sessionTimeoutMs = 10;
    private final int rebalanceTimeoutMs = 60;
    private final int heartbeatIntervalMs = 2;
    private final long retryBackoffMs = 100L;

    @Before
    public void setup() {
        this.time = new MockTime();
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE, new LogContext(), new ClusterResourceListeners());
        this.client = new MockClient((Time)this.time, new MockClient.MockMetadataUpdater(){

            public List<Node> fetchNodes() {
                return SchemaRegistryCoordinatorTest.this.cluster.nodes();
            }

            public boolean isUpdateNeeded() {
                return false;
            }

            public void update(Time time, MockClient.MetadataUpdate update) {
                throw new UnsupportedOperationException();
            }
        });
        this.logContext = new LogContext();
        this.consumerClient = new ConsumerNetworkClient(this.logContext, (KafkaClient)this.client, metadata, (Time)this.time, 100L, 1000, Integer.MAX_VALUE);
        this.metrics = new Metrics((Time)this.time);
        this.rebalanceListener = new MockRebalanceListener();
        this.member0RebalanceListener = new MockRebalanceListener();
        this.member1RebalanceListener = new MockRebalanceListener();
        this.member2RebalanceListener = new MockRebalanceListener();
        this.coordinator = new SchemaRegistryCoordinator(this.logContext, this.consumerClient, "test-group", 60, 10, 2, this.metrics, "sr-test-group", (Time)this.time, 100L, LEADER_INFO, (SchemaRegistryRebalanceListener)this.rebalanceListener, null, false);
    }

    @After
    public void teardown() {
        this.metrics.close();
    }

    @Test
    public void testMetadata() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection serialized = this.coordinator.metadata();
        Assert.assertEquals((long)1L, (long)serialized.size());
        JoinGroupRequestData.JoinGroupRequestProtocol defaultMetadata = (JoinGroupRequestData.JoinGroupRequestProtocol)serialized.iterator().next();
        Assert.assertEquals((Object)"v0", (Object)defaultMetadata.name());
        SchemaRegistryIdentity state = SchemaRegistryProtocol.deserializeMetadata((ByteBuffer)ByteBuffer.wrap(defaultMetadata.metadata()));
        Assert.assertEquals((Object)LEADER_INFO, (Object)state);
    }

    @Test
    public void testNormalJoinGroupLeader() {
        this.initiateFindJoinSyncFlow(LEADER_ID, this.coordinator, Collections.singletonMap(LEADER_ID, LEADER_INFO), true, LEADER_ID, LEADER_INFO, (short)0);
        this.validate(this.coordinator, this.rebalanceListener, 0, 1, false, LEADER_ID, LEADER_INFO);
    }

    @Test
    public void testJoinGroupLeaderNoneEligible() {
        this.initiateFindJoinSyncFlow(LEADER_ID, this.coordinator, Collections.singletonMap(LEADER_ID, INELIGIBLE_LEADER_INFO), true, null, null, (short)0);
        this.validate(this.coordinator, this.rebalanceListener, 0, 1, false, null, null);
    }

    @Test
    public void testJoinGroupLeaderDuplicateUrls() {
        HashMap<String, SchemaRegistryIdentity> memberInfo = new HashMap<String, SchemaRegistryIdentity>();
        memberInfo.put(LEADER_ID, LEADER_INFO);
        memberInfo.put(MEMBER_ID, LEADER_INFO);
        this.initiateFindJoinSyncFlow(LEADER_ID, this.coordinator, memberInfo, true, null, null, (short)1);
        this.validate(this.coordinator, this.rebalanceListener, 0, 1, true, null, null);
    }

    @Test
    public void testNormalJoinGroupFollower() {
        this.initiateFindJoinSyncFlow(MEMBER_ID, this.coordinator, null, false, LEADER_ID, LEADER_INFO, (short)0);
        this.validate(this.coordinator, this.rebalanceListener, 0, 1, false, LEADER_ID, LEADER_INFO);
    }

    @Test
    public void testCoordinatorDuringRollWithStickyLeaderElection() {
        this.initializeCoordinators(true);
        HashMap<String, SchemaRegistryIdentity> groupMembership = new HashMap<String, SchemaRegistryIdentity>();
        groupMembership.put(MEMBER_0, MEMBER_0_INFO);
        this.initiateFindJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_1, MEMBER_1_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateFindJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 1, 2, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_2, MEMBER_2_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateFindJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 2, 3, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 1, 2, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_2);
        this.member2Coordinator.setAssignmentSnapshot(null);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 3, 4, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 2, 3, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_2, MEMBER_2_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 4, 5, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 3, 4, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 0, 2, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_1);
        this.member1Coordinator.setAssignmentSnapshot(null);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 5, 6, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 1, 3, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_1, MEMBER_1_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 6, 7, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 3, 5, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 2, 4, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_0);
        this.member0Coordinator.setAssignmentSnapshot(null);
        this.member0Coordinator.getIdentity().setLeader(Boolean.valueOf(false));
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, true, MEMBER_1, MEMBER_1_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_1, MEMBER_1_INFO, (short)0);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 4, 6, false, MEMBER_1, MEMBER_1_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 3, 5, false, MEMBER_1, MEMBER_1_INFO);
        groupMembership.put(MEMBER_0, MEMBER_0_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_1_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_1_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_1_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 6, 8, false, MEMBER_0, MEMBER_1_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 5, 7, false, MEMBER_0, MEMBER_1_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 4, 6, false, MEMBER_0, MEMBER_1_INFO);
    }

    @Test
    public void testCoordinatorDuringRoll() {
        this.initializeCoordinators(false);
        HashMap<String, SchemaRegistryIdentity> groupMembership = new HashMap<String, SchemaRegistryIdentity>();
        groupMembership.put(MEMBER_0, MEMBER_0_INFO);
        this.initiateFindJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_1, MEMBER_1_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateFindJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 1, 2, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_2, MEMBER_2_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateFindJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 2, 3, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 1, 2, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 0, 1, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_2);
        this.member2Coordinator.setAssignmentSnapshot(null);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 3, 4, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 2, 3, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_2, MEMBER_2_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 4, 5, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 3, 4, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 0, 2, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_1);
        this.member1Coordinator.setAssignmentSnapshot(null);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 5, 6, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 1, 3, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.put(MEMBER_1, MEMBER_1_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 6, 7, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 3, 5, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 2, 4, false, MEMBER_0, MEMBER_0_INFO);
        groupMembership.remove(MEMBER_0);
        this.member0Coordinator.setAssignmentSnapshot(null);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, true, MEMBER_1, MEMBER_1_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_1, MEMBER_1_INFO, (short)0);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 4, 6, false, MEMBER_1, MEMBER_1_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 3, 5, false, MEMBER_1, MEMBER_1_INFO);
        groupMembership.put(MEMBER_0, MEMBER_0_INFO);
        this.initiateJoinSyncFlow(MEMBER_0, this.member0Coordinator, groupMembership, true, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_1, this.member1Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.initiateJoinSyncFlow(MEMBER_2, this.member2Coordinator, groupMembership, false, MEMBER_0, MEMBER_0_INFO, (short)0);
        this.validate(this.member0Coordinator, this.member0RebalanceListener, 6, 8, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member1Coordinator, this.member1RebalanceListener, 5, 7, false, MEMBER_0, MEMBER_0_INFO);
        this.validate(this.member2Coordinator, this.member2RebalanceListener, 4, 6, false, MEMBER_0, MEMBER_0_INFO);
    }

    private void initializeCoordinators(boolean stickyLeaderElection) {
        this.member0Coordinator = new SchemaRegistryCoordinator(this.logContext, this.consumerClient, "test-group", 60, 10, 2, new Metrics((Time)this.time), "sr-test-group", (Time)this.time, 100L, MEMBER_0_INFO, (SchemaRegistryRebalanceListener)this.member0RebalanceListener, null, stickyLeaderElection);
        this.member1Coordinator = new SchemaRegistryCoordinator(this.logContext, this.consumerClient, "test-group", 60, 10, 2, new Metrics((Time)this.time), "sr-test-group", (Time)this.time, 100L, MEMBER_1_INFO, (SchemaRegistryRebalanceListener)this.member1RebalanceListener, null, stickyLeaderElection);
        this.member2Coordinator = new SchemaRegistryCoordinator(this.logContext, this.consumerClient, "test-group", 60, 10, 2, new Metrics((Time)this.time), "sr-test-group", (Time)this.time, 100L, MEMBER_2_INFO, (SchemaRegistryRebalanceListener)this.member2RebalanceListener, null, stickyLeaderElection);
    }

    private void validate(SchemaRegistryCoordinator memberCoordinator, MockRebalanceListener memberRebalanceListener, int revokedCount, int assignedCount, boolean assignmentFailed, String leaderElector, SchemaRegistryIdentity leaderIdentity) {
        Assert.assertFalse((boolean)memberCoordinator.rejoinNeededOrPending());
        Assert.assertEquals((long)revokedCount, (long)memberRebalanceListener.revokedCount);
        Assert.assertEquals((long)assignedCount, (long)memberRebalanceListener.assignedCount);
        Assert.assertEquals((Object)assignmentFailed, (Object)memberRebalanceListener.assignments.get(assignedCount - 1).failed());
        Assert.assertEquals((Object)leaderElector, (Object)memberRebalanceListener.assignments.get(assignedCount - 1).leader());
        Assert.assertEquals((Object)leaderIdentity, (Object)memberRebalanceListener.assignments.get(assignedCount - 1).leaderIdentity());
    }

    private void initiateJoinSyncFlow(String member, SchemaRegistryCoordinator memberCoordinator, Map<String, SchemaRegistryIdentity> groupMembership, boolean isLeaderElector, String leaderElector, SchemaRegistryIdentity leaderIdentity, short assignmentError) {
        if (isLeaderElector) {
            this.client.prepareResponse((AbstractResponse)this.joinGroupLeaderResponse(1, member, groupMembership, Errors.NONE));
            SyncGroupResponse syncGroupResponse = this.syncGroupResponse(assignmentError, leaderElector, leaderIdentity, Errors.NONE);
            this.client.prepareResponse(body -> {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data().memberId().equals(member) && sync.data().generationId() == 1 && sync.groupAssignments().containsKey(member);
            }, (AbstractResponse)syncGroupResponse);
        } else {
            this.client.prepareResponse((AbstractResponse)this.joinGroupFollowerResponse(1, member, leaderElector, Errors.NONE));
            SyncGroupResponse syncGroupResponse = this.syncGroupResponse(assignmentError, leaderElector, leaderIdentity, Errors.NONE);
            this.client.prepareResponse(body -> {
                SyncGroupRequest sync = (SyncGroupRequest)body;
                return sync.data().memberId().equals(member) && sync.data().generationId() == 1;
            }, (AbstractResponse)syncGroupResponse);
        }
        memberCoordinator.requestRejoin("join group");
        memberCoordinator.ensureActiveGroup();
    }

    private void initiateFindJoinSyncFlow(String member, SchemaRegistryCoordinator memberCoordinator, Map<String, SchemaRegistryIdentity> groupMembership, boolean isLeaderElector, String leaderElector, SchemaRegistryIdentity leaderIdentity, short assignmentError) {
        this.client.prepareResponse((AbstractResponse)this.groupCoordinatorResponse(this.node, member, Errors.NONE));
        memberCoordinator.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
        this.initiateJoinSyncFlow(member, memberCoordinator, groupMembership, isLeaderElector, leaderElector, leaderIdentity, assignmentError);
    }

    private FindCoordinatorResponse groupCoordinatorResponse(Node node, String key, Errors error) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (String)key, (Node)node);
    }

    private JoinGroupResponse joinGroupLeaderResponse(int generationId, String memberId, Map<String, SchemaRegistryIdentity> memberLeaderEligibility, Errors error) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> metadata = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        for (Map.Entry<String, SchemaRegistryIdentity> configStateEntry : memberLeaderEligibility.entrySet()) {
            SchemaRegistryIdentity memberIdentity = configStateEntry.getValue();
            ByteBuffer buf = SchemaRegistryProtocol.serializeMetadata((SchemaRegistryIdentity)memberIdentity);
            metadata.add(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(configStateEntry.getKey()).setMetadata(buf.array()));
        }
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName("v0").setMemberId(memberId).setLeader(memberId).setMembers(metadata), 0);
    }

    private JoinGroupResponse joinGroupFollowerResponse(int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName("v0").setMemberId(memberId).setLeader(leaderId).setMembers(Collections.emptyList()), 0);
    }

    private SyncGroupResponse syncGroupResponse(short assignmentError, String leader, SchemaRegistryIdentity leaderIdentity, Errors error) {
        SchemaRegistryProtocol.Assignment assignment = new SchemaRegistryProtocol.Assignment(assignmentError, leader, leaderIdentity);
        ByteBuffer buf = SchemaRegistryProtocol.serializeAssignment((SchemaRegistryProtocol.Assignment)assignment);
        return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(error.code()).setAssignment(buf.array()));
    }

    private static class MockRebalanceListener
    implements SchemaRegistryRebalanceListener {
        public List<SchemaRegistryProtocol.Assignment> assignments = new ArrayList<SchemaRegistryProtocol.Assignment>();
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onAssigned(SchemaRegistryProtocol.Assignment assignment, int generation) {
            this.assignments.add(assignment);
            ++this.assignedCount;
        }

        public void onRevoked() {
            ++this.revokedCount;
        }
    }
}

