/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DeriveAvroSchema
extends DeriveSchema {
    public static final String DOUBLE = "double";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String NULL = "null";

    public DeriveAvroSchema() {
        this.classToDataType.put(DoubleNode.class.getName(), DOUBLE);
        this.classToDataType.put(TextNode.class.getName(), STRING);
        this.classToDataType.put(BigIntegerNode.class.getName(), DOUBLE);
        this.classToDataType.put(IntNode.class.getName(), INT);
        this.classToDataType.put(LongNode.class.getName(), LONG);
        this.classToDataType.put(BooleanNode.class.getName(), BOOLEAN);
        this.classToDataType.put(NullNode.class.getName(), NULL);
        this.classToDataType.put(MissingNode.class.getName(), NULL);
    }

    @Override
    protected ArrayNode mergeMultipleMessages(List<JsonNode> uniqueSchemas, Map<JsonNode, ArrayNode> schemaToIndex) {
        ArrayNode schemaInfoList = mapper.createArrayNode();
        ArrayList originalSchemaMatches = new ArrayList();
        uniqueSchemas.forEach(o -> originalSchemaMatches.add((ArrayNode)schemaToIndex.get(o)));
        try {
            this.mergeRecords(uniqueSchemas);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        HashMap schemaToMatches = new HashMap();
        uniqueSchemas.forEach(s -> schemaToMatches.put(s, mapper.createArrayNode()));
        for (int i = 0; i < uniqueSchemas.size(); ++i) {
            ((ArrayNode)schemaToMatches.get(uniqueSchemas.get(i))).addAll((ArrayNode)originalSchemaMatches.get(i));
        }
        for (JsonNode uniqueSchema : DeriveSchemaUtils.getUnique(uniqueSchemas)) {
            JsonNode uniqueSchemaCopy = uniqueSchema.deepCopy();
            this.updateSchemaInformation(uniqueSchemaCopy, (ArrayNode)schemaToMatches.get(uniqueSchema), schemaInfoList);
        }
        return schemaInfoList;
    }

    @Override
    protected ObjectNode mergeMultipleDataTypes(ObjectNode mergedArray, List<JsonNode> primitives, List<JsonNode> records, List<JsonNode> arrays, boolean check2dArray) {
        this.mergeUnions(records, primitives);
        DeriveSchemaUtils.mergeNumberTypes(primitives);
        primitives = DeriveSchemaUtils.getUnique(primitives);
        ArrayList<JsonNode> dataTypes = new ArrayList<JsonNode>();
        if (records.size() > 0) {
            this.mergeRecords(records);
        }
        if (arrays.size() > 0) {
            dataTypes.add((JsonNode)this.mergeArrays(arrays, true, false));
        }
        for (List types : Arrays.asList(records, primitives)) {
            dataTypes.addAll(types);
        }
        ArrayNode items = mapper.createArrayNode().addAll(DeriveSchemaUtils.getUnique(dataTypes));
        this.getSingleDataType(mergedArray, items);
        return mergedArray;
    }

    @Override
    protected JsonNode convertToFormat(JsonNode schema, String name) {
        ObjectNode schemaForRecord = this.convertToFormatForRecord(schema, name);
        AvroSchema avroSchema = new AvroSchema(schemaForRecord.toString());
        avroSchema.validate(false);
        try {
            return mapper.readTree(avroSchema.toString());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ObjectNode convertToFormatForRecord(JsonNode schema, String name) {
        ObjectNode recordSchemaAvro = mapper.createObjectNode().put("type", "record");
        recordSchemaAvro.put("name", name);
        JsonNode properties = schema.get("properties");
        ArrayNode fields = mapper.createArrayNode();
        for (String fieldName : DeriveSchemaUtils.getSortedKeys(properties)) {
            ObjectNode fieldSchemaAvro = mapper.createObjectNode().put("name", fieldName);
            this.setSchemaFields(fieldSchemaAvro, properties.get(fieldName), "type", fieldName);
            fields.add((JsonNode)fieldSchemaAvro);
        }
        recordSchemaAvro.set("fields", (JsonNode)fields);
        return recordSchemaAvro;
    }

    protected ObjectNode convertToFormatArray(JsonNode schema, String name) {
        ObjectNode arraySchemaAvro = mapper.createObjectNode().put("type", "array");
        this.setSchemaFields(arraySchemaAvro, schema.get("items"), "items", name);
        return arraySchemaAvro;
    }

    private void setSchemaFields(ObjectNode arraySchemaAvro, JsonNode items, String fieldType, String name) {
        String itemsType;
        switch (itemsType = items.get("type").asText()) {
            case "object": {
                arraySchemaAvro.set(fieldType, this.convertToFormat(items, name));
                break;
            }
            case "array": {
                arraySchemaAvro.set(fieldType, (JsonNode)this.convertToFormatArray(items, name));
                break;
            }
            case "union": {
                arraySchemaAvro.set(fieldType, (JsonNode)this.convertToFormatUnion(items));
                break;
            }
            default: {
                arraySchemaAvro.put(fieldType, itemsType);
            }
        }
    }

    private ArrayNode convertToFormatUnion(JsonNode items) {
        ArrayNode unionBranches = (ArrayNode)items.get("properties");
        for (int i = 0; i < unionBranches.size(); ++i) {
            if (!unionBranches.get(i).get("type").asText().equals("object")) continue;
            unionBranches.set(i, this.convertToFormat(unionBranches.get(i), unionBranches.get(i).get("__name").asText()));
        }
        return unionBranches;
    }

    protected void mergeUnions(List<JsonNode> records, List<JsonNode> primitives) {
        HashMap<String, List<JsonNode>> nameToField = new HashMap<String, List<JsonNode>>();
        boolean typeUnion = true;
        for (JsonNode record : records) {
            JsonNode properties = record.get("properties");
            if (properties.size() != 1) {
                typeUnion = false;
            }
            Iterator it = properties.fieldNames();
            while (it.hasNext()) {
                if (this.checkForUnion((String)it.next(), properties, nameToField)) continue;
                typeUnion = false;
            }
        }
        ArrayList<JsonNode> branches = new ArrayList<JsonNode>();
        for (Map.Entry entry : nameToField.entrySet()) {
            List<JsonNode> uniqueRecords = DeriveSchemaUtils.getUnique((List)entry.getValue());
            JsonNode mergedArray = this.mergeArrays(uniqueRecords, false, false).get("items");
            DeriveSchemaUtils.replaceEachField(mergedArray, (List)entry.getValue());
            branches.add(uniqueRecords.get(0));
        }
        if (typeUnion) {
            this.updateUnionBranches(records, primitives, branches);
        }
    }

    private boolean checkForUnion(String fieldName, JsonNode properties, Map<String, List<JsonNode>> nameToField) {
        List<String> numTypes = Arrays.asList(INT, LONG, DOUBLE);
        List<String> otherUnionTypes = Arrays.asList(STRING, BOOLEAN, "array");
        ObjectNode field = (ObjectNode)properties.get(fieldName);
        String fieldType = field.get("type").asText();
        boolean unionType = false;
        if (fieldType.equals("object") || fieldType.equals(NULL)) {
            field.put("__name", fieldName);
            unionType = true;
        } else if (numTypes.contains(fieldName) && numTypes.contains(fieldType) || otherUnionTypes.contains(fieldType) && fieldType.equals(fieldName)) {
            field.put("type", fieldName);
            unionType = true;
        }
        if (unionType) {
            List fields = nameToField.getOrDefault(fieldName, new ArrayList());
            fields.add(field);
            nameToField.put(fieldName, fields);
        }
        return unionType;
    }

    private void updateUnionBranches(List<JsonNode> records, List<JsonNode> primitives, List<JsonNode> branches) {
        boolean checkForSinglePrimitiveBranch;
        boolean hasNull = primitives.stream().anyMatch(o -> o.get("type").asText().equals(NULL));
        if (hasNull) {
            branches.add(this.getNullSchema());
        }
        List existingUnions = primitives.stream().filter(o -> o.get("type").asText().equals("union")).collect(Collectors.toList());
        for (JsonNode unionType : existingUnions) {
            JsonNode properties = unionType.get("properties");
            properties.forEach(branches::add);
        }
        List<JsonNode> uniqueBranches = DeriveSchemaUtils.getUnique(branches);
        List<String> primitiveTypes = Arrays.asList(INT, LONG, DOUBLE, STRING, BOOLEAN);
        boolean bl = checkForSinglePrimitiveBranch = uniqueBranches.size() == 1 && primitiveTypes.contains(uniqueBranches.get(0).get("type").asText());
        if (uniqueBranches.size() > 1 || checkForSinglePrimitiveBranch) {
            if (hasNull) {
                primitives.removeIf(o -> o.get("type").asText().equals(NULL));
            }
            ArrayNode properties = DeriveSchemaUtils.sortJsonArrayList(mapper.createArrayNode().addAll(uniqueBranches));
            for (List types : Arrays.asList(records, existingUnions)) {
                for (JsonNode field : types) {
                    ObjectNode objectNode = (ObjectNode)field;
                    objectNode.put("type", "union");
                    objectNode.set("properties", (JsonNode)properties);
                }
            }
        }
    }
}

