/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeriveSchemaUtils {
    public static List<JsonNode> getUnique(List<JsonNode> schemas) {
        return schemas.stream().distinct().collect(Collectors.toList());
    }

    public static List<JsonNode> getListFromArray(JsonNode field) {
        ArrayList<JsonNode> objectList = new ArrayList<JsonNode>();
        field.forEach(objectList::add);
        return objectList;
    }

    public static List<String> getSortedKeys(JsonNode message) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator it = message.fieldNames();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        Collections.sort(keys);
        return keys;
    }

    public static void groupItems(JsonNode element, List<JsonNode> items, List<JsonNode> records, List<JsonNode> arrays) {
        if (element.isEmpty() || items.contains(element)) {
            return;
        }
        if (element.has("oneOf")) {
            element.get("oneOf").forEach(o -> DeriveSchemaUtils.groupItems(o, items, records, arrays));
            return;
        }
        String typeOfElement = element.get("type").asText();
        if (typeOfElement.equals("object")) {
            records.add(element);
        } else if (typeOfElement.equals("array")) {
            arrays.add(element);
        } else {
            items.add(element);
        }
    }

    public static ObjectNode sortObjectNode(ObjectNode node) {
        ObjectNode sortedObjectNode = JacksonMapper.INSTANCE.createObjectNode();
        DeriveSchemaUtils.getSortedKeys((JsonNode)node).forEach(key -> sortedObjectNode.set(key, node.get(key)));
        return sortedObjectNode;
    }

    public static void mergeNumberTypes(List<JsonNode> primitives) {
        String type = null;
        List<String> integerTypes = Arrays.asList("int", "long", "int32", "int64");
        for (String types : Arrays.asList("long", "int64", "double")) {
            if (!primitives.stream().anyMatch(o -> o.get("type").asText().equals(types))) continue;
            type = types;
        }
        if (type == null) {
            return;
        }
        for (JsonNode node : primitives) {
            if (!integerTypes.contains(node.get("type").asText())) continue;
            ((ObjectNode)node).put("type", type);
        }
    }

    public static void replaceEachField(JsonNode mergedArray, List<JsonNode> uniqueRecords) {
        for (JsonNode record : uniqueRecords) {
            ObjectNode objectNode = (ObjectNode)record;
            for (String field : DeriveSchemaUtils.getSortedKeys(mergedArray)) {
                objectNode.set(field, mergedArray.get(field));
            }
        }
    }

    public static ArrayNode sortJsonArrayList(ArrayNode array) {
        List<JsonNode> dataNodes = DeriveSchemaUtils.getListFromArray((JsonNode)array);
        Stream stream = dataNodes.stream().distinct();
        Stream<JsonNode> sortedDataNodes = array.size() > 0 && dataNodes.get(0).has("type") ? stream.sorted(Comparator.comparing(o -> o.get("type").asText())) : stream.sorted(Comparator.comparing(JsonNode::asInt));
        return JacksonMapper.INSTANCE.createArrayNode().addAll((Collection)sortedDataNodes.collect(Collectors.toList()));
    }
}

