/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaUtils;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class DeriveSchema {
    protected final HashMap<String, String> classToDataType = new HashMap();
    protected static final ObjectMapper mapper = JacksonMapper.INSTANCE;
    public static final String PRIMITIVE_SCHEMA_TYPE = "{\"type\":\"%s\"}";

    protected List<JsonNode> getSchemaOfAllElements(List<JsonNode> messages, String name) throws JsonProcessingException {
        ArrayList<JsonNode> schemaList = new ArrayList<JsonNode>();
        for (int i = 0; i < messages.size(); ++i) {
            try {
                schemaList.add(this.getSchemaOfElement(messages.get(i), name));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unable to find schema for message %d: %s", i, messages.get(i)), e);
            }
        }
        return schemaList;
    }

    private JsonNode getSchemaOfElement(JsonNode message, String name) throws JsonProcessingException {
        Optional<JsonNode> primitiveSchema = this.getPrimitiveSchema(message);
        this.checkName(name);
        if (primitiveSchema.isPresent()) {
            return primitiveSchema.get();
        }
        if (message instanceof ArrayNode) {
            return this.getSchemaForArray(DeriveSchemaUtils.getListFromArray(message), name);
        }
        return this.getSchemaForRecord((ObjectNode)mapper.valueToTree((Object)message));
    }

    protected void checkName(String name) {
    }

    public Optional<JsonNode> getPrimitiveSchema(JsonNode field) {
        String inferredType = field.getClass().getName();
        if (this.classToDataType.containsKey(inferredType)) {
            try {
                String schema = String.format(PRIMITIVE_SCHEMA_TYPE, this.classToDataType.get(inferredType));
                return Optional.of(mapper.readTree(schema));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public ObjectNode getSchemaForArray(List<JsonNode> messages, String name) throws JsonProcessingException {
        ObjectNode schema = mapper.createObjectNode().put("type", "array");
        List<JsonNode> schemaList = this.getSchemaOfAllElements(messages, name);
        try {
            ObjectNode items = this.mergeArrays(schemaList, false, true);
            schema.set("items", items.get("items"));
            return schema;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unable to find schema for array %s", name), e);
        }
    }

    public ObjectNode getSchemaForRecord(ObjectNode message) throws JsonProcessingException {
        ObjectNode schema = mapper.createObjectNode().put("type", "object");
        schema.set("properties", (JsonNode)mapper.createObjectNode());
        for (String fieldName : DeriveSchemaUtils.getSortedKeys((JsonNode)message)) {
            JsonNode field = message.get(fieldName);
            ObjectNode fields = (ObjectNode)schema.get("properties");
            fields.set(fieldName, this.getSchemaOfElement(field, fieldName));
        }
        return schema;
    }

    public ObjectNode mergeRecords(List<JsonNode> recordList) {
        ObjectNode properties = mapper.createObjectNode();
        HashMap<String, List> fieldToType = new HashMap<String, List>();
        for (JsonNode record : recordList) {
            JsonNode fields = record.get("properties");
            for (String fieldName : DeriveSchemaUtils.getSortedKeys(fields)) {
                List listOfTypesForField = fieldToType.getOrDefault(fieldName, new ArrayList());
                listOfTypesForField.add(fields.get(fieldName));
                fieldToType.put(fieldName, listOfTypesForField);
            }
        }
        IllegalArgumentException mergingError = null;
        String mergingErrorField = null;
        for (Map.Entry entry : fieldToType.entrySet()) {
            String fieldName;
            fieldName = (String)entry.getKey();
            List fieldTypes = (List)fieldToType.get(fieldName);
            try {
                ObjectNode items = this.mergeArrays(fieldTypes, false, false).deepCopy();
                properties.set(fieldName, items.get("items"));
                DeriveSchemaUtils.replaceEachField(items.get("items"), fieldTypes);
            }
            catch (IllegalArgumentException e) {
                mergingError = e;
                mergingErrorField = fieldName;
            }
        }
        if (mergingErrorField != null) {
            throw new IllegalArgumentException(String.format("Unable to merge field %s with types: %s", mergingErrorField, fieldToType.get(mergingErrorField)), mergingError);
        }
        ObjectNode mergedRecord = mapper.createObjectNode().put("type", "object");
        mergedRecord.set("properties", (JsonNode)DeriveSchemaUtils.sortObjectNode(properties));
        return mergedRecord;
    }

    public ObjectNode mergeArrays(List<JsonNode> arrayList, boolean useItems, boolean check2dArray) {
        ObjectNode mergedArray = mapper.createObjectNode().put("type", "array");
        ArrayList<JsonNode> primitives = new ArrayList<JsonNode>();
        ArrayList<JsonNode> records = new ArrayList<JsonNode>();
        ArrayList<JsonNode> arrays = new ArrayList<JsonNode>();
        for (JsonNode arrayElements : DeriveSchemaUtils.getUnique(arrayList)) {
            if (!useItems) {
                DeriveSchemaUtils.groupItems(arrayElements, primitives, records, arrays);
                continue;
            }
            DeriveSchemaUtils.groupItems(arrayElements.get("items"), primitives, records, arrays);
        }
        return this.mergeMultipleDataTypes(mergedArray, primitives, records, arrays, check2dArray);
    }

    protected JsonNode getNullSchema() {
        return this.getPrimitiveSchema((JsonNode)mapper.convertValue(null, NullNode.class)).get();
    }

    public ObjectNode getSchemaForMultipleMessages(List<JsonNode> messages) throws JsonProcessingException {
        List<JsonNode> schemas = this.getSchemaOfAllElements(messages, "Schema");
        List<JsonNode> uniqueSchemas = DeriveSchemaUtils.getUnique(schemas);
        HashMap<JsonNode, ArrayNode> schemaToIndex = new HashMap<JsonNode, ArrayNode>();
        uniqueSchemas.forEach(s -> schemaToIndex.put((JsonNode)s, mapper.createArrayNode()));
        for (int i = 0; i < schemas.size(); ++i) {
            ((ArrayNode)schemaToIndex.get(schemas.get(i))).add(i);
        }
        ArrayNode schemaInfoList = this.mergeMultipleMessages(uniqueSchemas, schemaToIndex);
        return (ObjectNode)mapper.createObjectNode().set("schemas", (JsonNode)schemaInfoList);
    }

    protected void updateSchemaInformation(JsonNode mergedSchema, ArrayNode messagesMatched, ArrayNode schemaInformationList) {
        ObjectNode schemaElement = mapper.createObjectNode();
        try {
            schemaElement.set("schema", this.convertToFormat(mergedSchema, "Schema"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable generate schema for %s", mergedSchema), e);
        }
        schemaElement.set("messagesMatched", (JsonNode)DeriveSchemaUtils.sortJsonArrayList(messagesMatched));
        schemaInformationList.add((JsonNode)schemaElement);
    }

    protected void getSingleDataType(ObjectNode mergedArray, ArrayNode items) {
        if (items.size() > 1) {
            throw new IllegalArgumentException(String.format("Found multiple data types: %s", items));
        }
        if (items.size() == 1) {
            mergedArray.set("items", items.get(0));
        } else {
            mergedArray.set("items", this.getNullSchema());
        }
    }

    protected abstract JsonNode convertToFormat(JsonNode var1, String var2);

    protected abstract ObjectNode mergeMultipleDataTypes(ObjectNode var1, List<JsonNode> var2, List<JsonNode> var3, List<JsonNode> var4, boolean var5);

    protected abstract ArrayNode mergeMultipleMessages(List<JsonNode> var1, Map<JsonNode, ArrayNode> var2);
}

