/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DeriveSchemaUtilsTest {
    private static final ObjectMapper mapper = new ObjectMapper();
    static final String TYPE_INT = "{\"type\":\"int\"}";
    static final String TYPE_LONG = "{\"type\":\"long\"}";
    static final String TYPE_INT_32 = "{\"type\":\"int32\"}";
    static final String TYPE_INT_64 = "{\"type\":\"int64\"}";
    static final String TYPE_DOUBLE = "{\"type\":\"double\"}";

    private ObjectNode getObjectNodeForSorting() {
        ObjectNode node = mapper.createObjectNode();
        node.put("Second", "1");
        node.put("First", "1");
        node.put("Third", "1");
        return node;
    }

    private void checkOrderOfKeys(List<String> sortedKeys) {
        Assert.assertEquals((long)sortedKeys.size(), (long)3L);
        Assert.assertEquals((Object)sortedKeys.get(0), (Object)"First");
        Assert.assertEquals((Object)sortedKeys.get(1), (Object)"Second");
        Assert.assertEquals((Object)sortedKeys.get(2), (Object)"Third");
    }

    @Test
    public void shouldGetDifferentUniqueElements() throws JsonProcessingException {
        ArrayList<JsonNode> schemas = new ArrayList<JsonNode>();
        for (String schema : Arrays.asList("{\"type\":\"array\",\"items\":{\"type\":\"number\"}}", "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"number\"}}}", "{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}")) {
            schemas.add(mapper.readTree(schema));
        }
        List uniqueSchemas = DeriveSchemaUtils.getUnique(schemas);
        Assert.assertEquals((long)uniqueSchemas.size(), (long)4L);
        for (JsonNode schema : schemas) {
            assert (uniqueSchemas.contains(schema));
        }
    }

    @Test
    public void testGetListFromArray() throws JsonProcessingException {
        ArrayNode arrayNode = mapper.createArrayNode();
        arrayNode.add(mapper.readTree(TYPE_LONG));
        arrayNode.add(mapper.readTree("{\"type\":\"array\",\"items\":{}}"));
        List objectList = DeriveSchemaUtils.getListFromArray((JsonNode)arrayNode);
        Assert.assertEquals((long)objectList.size(), (long)2L);
        Assert.assertEquals(objectList.get(0), (Object)mapper.readTree(TYPE_LONG));
        Assert.assertEquals(objectList.get(1), (Object)mapper.readTree("{\"type\":\"array\",\"items\":{}}"));
    }

    @Test
    public void testGetSortedKeys() {
        List sortedKeys = DeriveSchemaUtils.getSortedKeys((JsonNode)this.getObjectNodeForSorting());
        this.checkOrderOfKeys(sortedKeys);
    }

    @Test
    public void testSortObjectNode() {
        ObjectNode sortedObject = DeriveSchemaUtils.sortObjectNode((ObjectNode)this.getObjectNodeForSorting());
        ArrayList<String> sortedKeys = new ArrayList<String>();
        Iterator it = sortedObject.fieldNames();
        while (it.hasNext()) {
            sortedKeys.add((String)it.next());
        }
        this.checkOrderOfKeys(sortedKeys);
    }

    @Test
    public void shouldMergeNumberTypes() throws JsonProcessingException {
        ArrayList<JsonNode> schemas = new ArrayList<JsonNode>();
        for (String string : Arrays.asList(TYPE_INT, TYPE_LONG, TYPE_INT_32, TYPE_INT_64, TYPE_DOUBLE)) {
            schemas.add((JsonNode)mapper.readValue(string, ObjectNode.class));
        }
        DeriveSchemaUtils.mergeNumberTypes(schemas);
        for (JsonNode jsonNode : schemas) {
            Assert.assertEquals((Object)jsonNode, (Object)mapper.readValue(TYPE_DOUBLE, ObjectNode.class));
        }
    }

    @Test
    public void shouldMergeNumberTypesLong() throws JsonProcessingException {
        ArrayList<JsonNode> schemas = new ArrayList<JsonNode>();
        for (String string : Arrays.asList(TYPE_INT, TYPE_LONG)) {
            schemas.add((JsonNode)mapper.readValue(string, ObjectNode.class));
        }
        DeriveSchemaUtils.mergeNumberTypes(schemas);
        for (JsonNode jsonNode : schemas) {
            Assert.assertEquals((Object)jsonNode, (Object)mapper.readValue(TYPE_LONG, ObjectNode.class));
        }
    }

    @Test
    public void shouldGroupDifferentTypes() throws JsonProcessingException {
        ArrayList<ObjectNode> schemas = new ArrayList<ObjectNode>();
        for (String schema : Arrays.asList(TYPE_INT, String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F1"), "{\"type\":\"array\",\"items\":{\"type\":\"number\"}}", "{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"number\"},{\"type\":\"string\"}]}}")) {
            schemas.add((ObjectNode)mapper.readValue(schema, ObjectNode.class));
        }
        ArrayList primitives = new ArrayList();
        ArrayList records = new ArrayList();
        ArrayList arrays = new ArrayList();
        DeriveSchemaUtils.groupItems((JsonNode)((JsonNode)schemas.get(0)), primitives, records, arrays);
        Assert.assertEquals((long)primitives.size(), (long)1L);
        DeriveSchemaUtils.groupItems((JsonNode)((JsonNode)schemas.get(1)), primitives, records, arrays);
        Assert.assertEquals((long)records.size(), (long)1L);
        DeriveSchemaUtils.groupItems((JsonNode)((JsonNode)schemas.get(2)), primitives, records, arrays);
        Assert.assertEquals((long)arrays.size(), (long)1L);
        DeriveSchemaUtils.groupItems((JsonNode)((JsonNode)schemas.get(3)), primitives, records, arrays);
        Assert.assertEquals((long)arrays.size(), (long)2L);
    }

    @Test
    public void testSortJsonArrayList() throws JsonProcessingException {
        ArrayNode oneOfList = mapper.createArrayNode();
        for (String schema : Arrays.asList(TYPE_LONG, TYPE_DOUBLE, "{\"type\":\"array\",\"items\":{}}", String.format("{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}", "F1"))) {
            oneOfList.add(mapper.readTree(schema));
        }
        ArrayNode sortedOneOfList = DeriveSchemaUtils.sortJsonArrayList((ArrayNode)oneOfList);
        Assert.assertEquals((Object)sortedOneOfList.toString(), (Object)"[{\"type\":\"array\",\"items\":{}},{\"type\":\"double\"},{\"type\":\"long\"},{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"string\"}}}]");
    }

    @Test
    public void testSortJsonArrayListInteger() {
        ArrayNode array = mapper.createArrayNode();
        for (int i = 0; i < 5; ++i) {
            array.add(i * (i - 2));
        }
        ArrayNode sortedArray = DeriveSchemaUtils.sortJsonArrayList((ArrayNode)array);
        Assert.assertEquals((Object)sortedArray.toString(), (Object)"[-1,0,3,8]");
    }
}

