/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.basicauth;

import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.client.security.basicauth.SaslBasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.UrlBasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.UserInfoCredentialProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BasicAuthCredentialProviderFactoryTest {
    @Parameterized.Parameter
    public String userInfoConfigName;
    private Map<String, String> CONFIG_MAP = new HashMap<String, String>();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"basic.auth.user.info"}, {"schema.registry.basic.auth.user.info"});
    }

    @Before
    public void setup() throws IOException {
        this.CONFIG_MAP.put(this.userInfoConfigName, "user:password");
        File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
        jaasConfigFile.deleteOnExit();
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("KafkaClient { org.apache.kafka.common.security.plain.PlainLoginModule required username=\"user\" password=\"password\";};");
        Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        Configuration.setConfiguration(null);
    }

    @Test
    public void testSuccess() {
        this.assertInstance(BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"URL", this.CONFIG_MAP), UrlBasicAuthCredentialProvider.class);
        this.assertInstance(BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"USER_INFO", this.CONFIG_MAP), UserInfoCredentialProvider.class);
        this.assertInstance(BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"SASL_INHERIT", this.CONFIG_MAP), SaslBasicAuthCredentialProvider.class);
    }

    @Test
    public void testUnknownProvider() {
        Assert.assertNull((Object)BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"UNKNOWN", this.CONFIG_MAP));
    }

    public void assertInstance(BasicAuthCredentialProvider instance, Class<? extends BasicAuthCredentialProvider> klass) {
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(klass, instance.getClass());
    }
}

