/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import io.confluent.kafka.schemaregistry.client.rest.utils.SchemaRegistryDiscoveryClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegistryDiscoveryClientTest
extends EasyMockSupport {
    public static final String ZK_URL_MOCK = "zk-url";

    @Test(expected=IllegalStateException.class)
    public void whenSrUrlsDirectoryIsMissingThrowsAnException() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)false).once();
        zkClient.close();
        EasyMock.expectLastCall();
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_");
        this.replayAll();
        try {
            extractor.discoverUrls();
        }
        finally {
            this.verifyAll();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void whenUrlsDirectoryIsEmptyThrowsAnException() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).once();
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andReturn(Collections.emptyList());
        zkClient.close();
        EasyMock.expectLastCall();
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_");
        this.replayAll();
        try {
            extractor.discoverUrls();
        }
        finally {
            this.verifyAll();
        }
    }

    @Test
    public void whenUrlRecordIsAvailable() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).once();
        String child = "url1";
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andReturn(Collections.singletonList(child));
        String url = "localhost";
        EasyMock.expect((Object)zkClient.readData("/sr_urls/" + child)).andReturn((Object)url);
        zkClient.close();
        EasyMock.expectLastCall();
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_");
        this.replayAll();
        List result = extractor.discoverUrls();
        this.verifyAll();
        Assert.assertEquals(Collections.singletonList(url), (Object)result);
    }

    @Test
    public void whenFewUrlRecordsAreAvailable() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).once();
        String child1 = "url1";
        String child2 = "url2";
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andReturn(Arrays.asList(child1, child2));
        String url1 = "localhost";
        String url2 = "localhost2";
        EasyMock.expect((Object)zkClient.readData("/sr_urls/" + child1)).andReturn((Object)url1);
        EasyMock.expect((Object)zkClient.readData("/sr_urls/" + child2)).andReturn((Object)url2);
        zkClient.close();
        EasyMock.expectLastCall();
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_");
        this.replayAll();
        List result = extractor.discoverUrls();
        this.verifyAll();
        Assert.assertEquals(Arrays.asList(url1, url2), (Object)result);
    }

    @Test
    public void whenServiceIdIsNotDefaultBuildsCorrectUrl() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).once();
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andReturn(Collections.singletonList("url1"));
        EasyMock.expect((Object)zkClient.readData("/sr_urls/url1")).andReturn((Object)"localhost");
        zkClient.close();
        EasyMock.expectLastCall();
        String newServiceId = "newService";
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, newServiceId).serviceId(newServiceId);
        this.replayAll();
        extractor.discoverUrls();
        this.verifyAll();
    }

    @Test
    public void whenRetriesFailThrowsLastException() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        int retries = 2;
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).times(retries);
        RuntimeException expectedException = new RuntimeException("expected");
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andThrow((Throwable)new RuntimeException("unexpected")).andThrow((Throwable)expectedException);
        zkClient.close();
        EasyMock.expectLastCall().times(retries);
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_").retries(retries);
        this.replayAll();
        try {
            extractor.discoverUrls();
            Assert.fail((String)("Expected exception: " + expectedException));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expectedException, (Object)e);
        }
        this.verifyAll();
    }

    @Test
    public void stopsRetryingWhenUrlsAreAvailable() {
        ZkClient zkClient = (ZkClient)this.mock(ZkClient.class);
        int expectedNumberOfRetries = 3;
        EasyMock.expect((Object)zkClient.exists("/sr_urls")).andReturn((Object)true).times(expectedNumberOfRetries);
        EasyMock.expect((Object)zkClient.getChildren("/sr_urls")).andThrow((Throwable)new RuntimeException("unexpected")).andReturn(Collections.emptyList()).andReturn(Collections.singletonList("expected"));
        String expectedUrl = "expected-url";
        EasyMock.expect((Object)zkClient.readData("/sr_urls/expected")).andReturn((Object)expectedUrl);
        zkClient.close();
        EasyMock.expectLastCall().times(expectedNumberOfRetries);
        SchemaRegistryDiscoveryClient extractor = this.spiedExtractor(zkClient, "default_").retries(expectedNumberOfRetries + 1);
        this.replayAll();
        List result = extractor.discoverUrls();
        this.verifyAll();
        Assert.assertEquals(Collections.singletonList(expectedUrl), (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deniesEmptyServiceId() {
        new SchemaRegistryDiscoveryClient().serviceId("");
    }

    private SchemaRegistryDiscoveryClient spiedExtractor(ZkClient zkClient, String serviceId) {
        SchemaRegistryDiscoveryClient extractor = (SchemaRegistryDiscoveryClient)this.partialMockBuilder(SchemaRegistryDiscoveryClient.class).withConstructor().addMockedMethods(new String[]{"getZkUrl", "createZkClient"}).createMock();
        EasyMock.expect((Object)extractor.getZkUrl()).andReturn((Object)ZK_URL_MOCK).atLeastOnce();
        String expectedZkUrl = "zk-url/schema_registry_" + serviceId;
        EasyMock.expect((Object)extractor.createZkClient(expectedZkUrl)).andReturn((Object)zkClient).atLeastOnce();
        return extractor.retries(1).retryInterval(1L);
    }
}

