/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RestServiceTest {
    @Mock
    private URL url;

    @Test
    public void buildRequestUrl_trimNothing() {
        String baseUrl = "http://test.com";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrl() {
        String baseUrl = "http://test.com/";
        String path = "some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimPath() {
        String baseUrl = "http://test.com";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void buildRequestUrl_trimBaseUrlAndPath() {
        String baseUrl = "http://test.com/";
        String path = "/some/path";
        TestCase.assertEquals((String)"http://test.com/some/path", (String)RestService.buildRequestUrl((String)baseUrl, (String)path));
    }

    @Test
    public void testSetForwardHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8081", true);
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getURL()).thenReturn((Object)this.url);
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)httpURLConnection.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            byte[] b = (byte[])invocationOnMock.getArgument(0);
            byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(json, 0, b, 0, json.length);
            return json.length;
        });
        HashMap<String, String> headerProperties = new HashMap<String, String>();
        headerProperties.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        restServiceSpy.getAllSubjects(headerProperties);
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("X-Forward", "true");
    }

    @Test
    public void testSetBasicAuthRequestHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8087");
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        BasicAuthCredentialProvider basicAuthCredentialProvider = (BasicAuthCredentialProvider)Mockito.mock(BasicAuthCredentialProvider.class);
        restServiceSpy.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getURL()).thenReturn((Object)this.url);
        Mockito.when((Object)basicAuthCredentialProvider.getUserInfo((URL)ArgumentMatchers.any(URL.class))).thenReturn((Object)"user:password");
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)httpURLConnection.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            byte[] b = (byte[])invocationOnMock.getArgument(0);
            byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(json, 0, b, 0, json.length);
            return json.length;
        });
        restServiceSpy.getAllSubjects();
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("Authorization", "Basic dXNlcjpwYXNzd29yZA==");
    }

    public void testSetBearerAuthRequestHeader() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        BearerAuthCredentialProvider bearerAuthCredentialProvider = (BearerAuthCredentialProvider)Mockito.mock(BearerAuthCredentialProvider.class);
        restServiceSpy.setBearerAuthCredentialProvider(bearerAuthCredentialProvider);
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getURL()).thenReturn((Object)this.url);
        Mockito.when((Object)bearerAuthCredentialProvider.getBearerToken((URL)ArgumentMatchers.any(URL.class))).thenReturn((Object)"auth-token");
        Mockito.when((Object)bearerAuthCredentialProvider.getTargetSchemaRegistry()).thenReturn((Object)"lsrc-dummy");
        Mockito.when((Object)bearerAuthCredentialProvider.getTargetIdentityPoolId()).thenReturn((Object)"my-pool-id");
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)httpURLConnection.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            byte[] b = (byte[])invocationOnMock.getArgument(0);
            byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(json, 0, b, 0, json.length);
            return json.length;
        });
        restServiceSpy.getAllSubjects();
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("Authorization", "Bearer auth-token");
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("target-sr-cluster", "lsrc-dummy");
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("Confluent-Identity-Pool-Id", "my-pool-id");
    }

    @Test
    public void testSetHttpHeaders() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        restServiceSpy.setHttpHeaders((Map)ImmutableMap.of((Object)"api-key", (Object)"test-api-key", (Object)"source-app", (Object)"foo"));
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)httpURLConnection.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            byte[] b = (byte[])invocationOnMock.getArgument(0);
            byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(json, 0, b, 0, json.length);
            return json.length;
        });
        restServiceSpy.getAllSubjects();
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("api-key", "test-api-key");
        ((HttpURLConnection)Mockito.verify((Object)httpURLConnection)).setRequestProperty("source-app", "foo");
    }

    @Test
    public void testErrorResponseWithNullErrorStreamFromConnection() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)this.url.openConnection()).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)400);
        Mockito.when((Object)httpURLConnection.getErrorStream()).thenReturn(null);
        try {
            restServiceSpy.getAllSubjects();
            Assert.fail((String)"Expected RestClientException to be thrown");
        }
        catch (RestClientException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("error code: 50005"));
        }
    }

    @Test
    public void testSetProxy() throws Exception {
        RestService restService = new RestService("http://localhost:8081");
        RestService restServiceSpy = (RestService)Mockito.spy((Object)restService);
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("proxy.host", "http://localhost");
        configs.put("proxy.port", 8080);
        restServiceSpy.configure(configs);
        ((RestService)Mockito.doReturn((Object)this.url).when((Object)restServiceSpy)).url(ArgumentMatchers.anyString());
        Mockito.when((Object)httpURLConnection.getResponseCode()).thenReturn((Object)200);
        Mockito.when((Object)this.url.openConnection((Proxy)ArgumentMatchers.any())).thenReturn((Object)httpURLConnection);
        Mockito.when((Object)httpURLConnection.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> {
            byte[] b = (byte[])invocationOnMock.getArgument(0);
            byte[] json = "[\"abc\"]".getBytes(StandardCharsets.UTF_8);
            System.arraycopy(json, 0, b, 0, json.length);
            return json.length;
        });
        restServiceSpy.getAllSubjects();
        ArgumentCaptor proxyCaptor = ArgumentCaptor.forClass(Proxy.class);
        ((URL)Mockito.verify((Object)this.url)).openConnection((Proxy)proxyCaptor.capture());
        InetSocketAddress inetAddress = (InetSocketAddress)((Proxy)proxyCaptor.getValue()).address();
        TestCase.assertEquals((String)"http://localhost", (String)inetAddress.getHostName());
        TestCase.assertEquals((int)8080, (int)inetAddress.getPort());
    }
}

