/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.config.ConfigException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.management.*", "javax.xml.*", "org.apache.xerces.*", "org.w3c.*", "javax.security.*", "javax.net.ssl.*"})
@PrepareForTest(value={UserGroupInformation.class})
@RunWith(value=PowerMockRunner.class)
@SuppressStaticInitializationFor(value={"com.mapr.baseutils.JVMProperties"})
public class CachedSchemaRegistryClientTest {
    private static final int CACHE_CAPACITY = 5;
    private static final String SCHEMA_STR_0 = CachedSchemaRegistryClientTest.avroSchemaString(0);
    private static final AvroSchema AVRO_SCHEMA_0 = CachedSchemaRegistryClientTest.avroSchema(0);
    private static final AvroSchema SCHEMA_WITH_DECIMAL = new AvroSchema("{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"scale\": 4,\n                    \"precision\": 17,\n                    \"logicalType\": \"decimal\"\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}");
    private static final AvroSchema SCHEMA_WITH_DECIMAL2 = new AvroSchema("{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"logicalType\": \"decimal\",\n                    \"precision\": 17,\n                    \"scale\": 4\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}");
    private static final String SUBJECT_0 = "foo";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int ID_25 = 25;
    private static final int ID_50 = 50;
    private static final Schema SCHEMA_DETAILS = new Schema("foo", Integer.valueOf(7), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0);
    private RestService restService;

    @Before
    public void setUp() {
        this.restService = (RestService)EasyMock.createNiceMock(RestService.class);
        PowerMock.mockStaticPartial(UserGroupInformation.class, (String[])new String[]{"getLoginUser", "isSecurityEnabled"});
        EasyMock.expect((Object)UserGroupInformation.isSecurityEnabled()).andReturn((Object)false).anyTimes();
    }

    private CachedSchemaRegistryClient createSchemaRegistryClient() {
        return new CachedSchemaRegistryClient(this.restService, 5, new HashMap());
    }

    @Test
    public void testHttpHeaderConfiguration() {
        Map<String, String> headers = Collections.singletonMap("Authorization", "Bearer RGFuIGlzIGEgZG93bmVy");
        this.restService.setHttpHeaders((Map)EasyMock.eq(headers));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.restService});
        new CachedSchemaRegistryClient(this.restService, 5, null, headers);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDuplicateClientNamespaceConfiguration() {
        Map<String, String> configs = Collections.singletonMap("key", "value");
        this.restService.configure(configs);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.restService});
        HashMap<String, String> duplicateConfigs = new HashMap<String, String>();
        duplicateConfigs.put("key", "value");
        duplicateConfigs.put("schema.registry.key", "value");
        new CachedSchemaRegistryClient(this.restService, 5, duplicateConfigs, null);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterSchemaCacheWithVersionAndId() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0, 1, 25));
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0, 1, 25));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterEquivalentSchemaDifferentid() throws Exception {
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(50)).once();
        EasyMock.replay((Object[])new Object[]{this.restService});
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)SCHEMA_WITH_DECIMAL, 1, 25));
        Assert.assertEquals((long)50L, (long)client.register(SUBJECT_0, (ParsedSchema)SCHEMA_WITH_DECIMAL2, 2, 50));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testRegisterOverCapacity() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), EasyMock.anyString(), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).andReturn((Object)new RegisterSchemaResponse(26)).andReturn((Object)new RegisterSchemaResponse(27)).andReturn((Object)new RegisterSchemaResponse(28)).andReturn((Object)new RegisterSchemaResponse(29)).andReturn((Object)new RegisterSchemaResponse(30));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        for (int i = 0; i != 5; ++i) {
            client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(i));
        }
        client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(5));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andReturn((Object)new SchemaString(SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(SUBJECT_0, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(SUBJECT_0, 25)).rawSchema());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testIdenticalSchemas() throws Exception {
        SchemaString schemaStringOne = new SchemaString(SCHEMA_STR_0);
        SchemaString schemaStringTwo = new SchemaString(SCHEMA_STR_0);
        String subjectOne = "subjectOne";
        String subjectTwo = "subjectTwo";
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectOne), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)subjectTwo), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.getId(25, subjectOne)).andReturn((Object)schemaStringOne);
        EasyMock.expect((Object)this.restService.getId(25, subjectTwo)).andReturn((Object)schemaStringTwo);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(subjectOne, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(subjectTwo, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(subjectOne, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(subjectTwo, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(subjectOne, 25)).rawSchema());
        Assert.assertEquals((Object)AVRO_SCHEMA_0.rawSchema(), (Object)((AvroSchema)client.getSchemaBySubjectAndId(subjectTwo, 25)).rawSchema());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteSchemaCache() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).once();
        EasyMock.expect((Object)this.restService.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, false)).andReturn(Arrays.asList(0));
        EasyMock.expect((Object)this.restService.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, true)).andReturn(Arrays.asList(1));
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals(Arrays.asList(0), (Object)client.deleteSubject(SUBJECT_0));
        Assert.assertEquals(Arrays.asList(1), (Object)client.deleteSubject(SUBJECT_0, true));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testDeleteVersionCache() throws Exception {
        int version = 7;
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25));
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)true))).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, String.valueOf(version), false)).andReturn((Object)0);
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, SUBJECT_0, String.valueOf(version), true)).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((long)25L, (long)client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((long)version, (long)client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0));
        Assert.assertEquals((Object)0, (Object)client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version)));
        Assert.assertEquals((Object)1, (Object)client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version), true));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testSetMode() throws Exception {
        String mode = "READONLY";
        EasyMock.reset((Object[])new Object[]{this.restService});
        ModeUpdateRequest modeUpdateRequest = new ModeUpdateRequest();
        modeUpdateRequest.setMode("READONLY");
        EasyMock.expect((Object)this.restService.setMode((String)EasyMock.eq((Object)"READONLY"))).andReturn((Object)modeUpdateRequest);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((Object)"READONLY", (Object)client.setMode("READONLY"));
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test
    public void testGetMode() throws Exception {
        String mode = "READONLY";
        EasyMock.reset((Object[])new Object[]{this.restService});
        Mode modeGetResponse = new Mode("READONLY");
        EasyMock.expect((Object)this.restService.getMode()).andReturn((Object)modeGetResponse);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Assert.assertEquals((Object)"READONLY", (Object)client.getMode());
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    public void testDeleteVersionNotInVersionCache() throws Exception {
        EasyMock.expect((Object)this.restService.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0")).andReturn((Object)10);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        Integer result = client.deleteSchemaVersion(Collections.emptyMap(), SUBJECT_0, "0");
        Assert.assertEquals((Object)10, (Object)result);
        EasyMock.verify((Object[])new Object[]{this.restService});
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteNullSubjectThrows() throws Exception {
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        client.deleteSubject(null);
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteNullSubjectThrowsPermanent() throws Exception {
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        client.deleteSubject(null, true);
    }

    @Test
    public void testThreadSafe() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).anyTimes();
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andReturn((Object)new SchemaString(SCHEMA_STR_0)).anyTimes();
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn((Object)SCHEMA_DETAILS).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        IntStream.range(0, 1000).parallel().forEach(idx -> {
            try {
                int id = client.register(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                int version = client.getVersion(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
                client.getBySubjectAndId(SUBJECT_0, id);
                client.deleteSchemaVersion(SUBJECT_0, String.valueOf(version));
                client.deleteSubject(SUBJECT_0);
            }
            catch (RestClientException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test(expected=ConfigException.class)
    public void testMultipleCredentialProvider() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("basic.auth.credentials.source", "URL");
        config.put("bearer.auth.credentials.source", "STATIC_TOKEN");
        config.put("bearer.auth.token", "auth-token");
        new CachedSchemaRegistryClient(new RestService("http://user:password@sr.com:8020"), 5, config, null);
    }

    @Test
    public void testGetSchemas() throws Exception {
        EasyMock.expect((Object)this.restService.registerSchema((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), EasyMock.anyString(), EasyMock.anyBoolean())).andReturn((Object)new RegisterSchemaResponse(25)).andReturn((Object)new RegisterSchemaResponse(26)).andReturn((Object)new RegisterSchemaResponse(27)).andReturn((Object)new RegisterSchemaResponse(28)).andReturn((Object)new RegisterSchemaResponse(29));
        List schemas = IntStream.range(0, 5).mapToObj(idx -> new Schema(SUBJECT_0, Integer.valueOf(7), Integer.valueOf(idx + 25), "AVRO", Collections.emptyList(), CachedSchemaRegistryClientTest.avroSchemaString(idx))).collect(Collectors.toList());
        EasyMock.expect((Object)this.restService.getSchemas(EasyMock.anyString(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn(schemas);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        for (int i = 0; i != 5; ++i) {
            client.register(SUBJECT_0, (ParsedSchema)CachedSchemaRegistryClientTest.avroSchema(i));
        }
        List parsedSchemas = client.getSchemas(SUBJECT_0, false, true);
        Assert.assertEquals((long)5L, (long)parsedSchemas.size());
        IntStream.range(0, 5).forEach(idx -> {
            Assert.assertEquals((Object)new AvroSchema(CachedSchemaRegistryClientTest.avroSchemaString(idx)), parsedSchemas.get(idx));
            Assert.assertEquals((Object)"AVRO", (Object)((ParsedSchema)parsedSchemas.get(idx)).schemaType());
        });
    }

    @Test
    public void testGetSchemasEmptyReturn() throws Exception {
        List emptyList = Collections.emptyList();
        EasyMock.expect((Object)this.restService.getSchemas(EasyMock.anyString(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn(emptyList);
        EasyMock.replay((Object[])new Object[]{this.restService});
        CachedSchemaRegistryClient client = this.createSchemaRegistryClient();
        List parsedSchemas = client.getSchemas(SUBJECT_0, false, true);
        Assert.assertEquals((long)0L, (long)parsedSchemas.size());
    }

    @Test
    public void testMissingIdCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        EasyMock.expect((Object)this.restService.getId(25, SUBJECT_0)).andThrow((Throwable)new RestClientException("Schema 25 not found", 404, 40403)).andReturn((Object)new SchemaString(SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            client.getSchemaBySubjectAndId(SUBJECT_0, 25);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema 25 not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            client.getSchemaBySubjectAndId(SUBJECT_0, 25);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema 25 not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)client.getSchemaBySubjectAndId(SUBJECT_0, 25));
    }

    @Test
    public void testMissingSubjectCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        int version = 7;
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)false))).andThrow((Throwable)new RestClientException("Subject not found", 404, 40401)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Subject not found; error code: 40401", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
    }

    @Test
    public void testMissingSchemaCache() throws Exception {
        HashMap<String, Long> configs = new HashMap<String, Long>();
        configs.put("missing.id.cache.ttl.sec", 60L);
        configs.put("missing.schema.cache.ttl.sec", 60L);
        FakeTicker fakeTicker = new FakeTicker();
        CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(this.restService, 5, null, configs, null, (Ticker)fakeTicker);
        int version = 7;
        EasyMock.expect((Object)this.restService.lookUpSubjectVersion((RegisterSchemaRequest)EasyMock.anyObject(RegisterSchemaRequest.class), (String)EasyMock.eq((Object)SUBJECT_0), EasyMock.anyBoolean(), EasyMock.eq((boolean)false))).andThrow((Throwable)new RestClientException("Schema not found", 404, 40403)).andReturn((Object)new Schema(SUBJECT_0, Integer.valueOf(version), Integer.valueOf(25), "AVRO", Collections.emptyList(), SCHEMA_STR_0));
        EasyMock.replay((Object[])new Object[]{this.restService});
        try {
            client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(59L, TimeUnit.SECONDS);
        try {
            client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
            Assert.fail();
        }
        catch (RestClientException rce) {
            Assert.assertEquals((Object)"Schema not found; error code: 40403", (Object)rce.getMessage());
        }
        fakeTicker.advance(2L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        client.getId(SUBJECT_0, (ParsedSchema)AVRO_SCHEMA_0);
    }

    private static AvroSchema avroSchema(int i) {
        return new AvroSchema(CachedSchemaRegistryClientTest.avroSchemaString(i));
    }

    private static String avroSchemaString(int i) {
        return "{\"type\": \"record\", \"name\": \"Blah" + i + "\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" }]}";
    }
}

