/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import java.time.Instant;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.BasicOAuthBearerToken;
import org.junit.Assert;
import org.junit.Test;

public class OauthTokenCacheTest {
    private short cacheExpiryBufferSeconds = 1;
    private OauthTokenCache oAuthTokenCache = new OauthTokenCache(this.cacheExpiryBufferSeconds);
    private String tokenString1 = "token1";

    @Test
    public void TestSetCurrentToken() {
        BasicOAuthBearerToken token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), 100L, "random", Long.valueOf(0L));
        this.oAuthTokenCache.setCurrentToken((OAuthBearerToken)token1);
        Assert.assertEquals((Object)this.tokenString1, (Object)this.oAuthTokenCache.getCurrentToken().value());
    }

    @Test
    public void TestIsExpiredWithNull() {
        this.oAuthTokenCache.setCurrentToken(null);
        Assert.assertEquals((Object)true, (Object)this.oAuthTokenCache.isTokenExpired());
    }

    @Test
    public void TestIsExpiredWithValidCache() throws InterruptedException {
        Long lifespan = 2L;
        BasicOAuthBearerToken token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), Instant.now().plusSeconds(lifespan).toEpochMilli(), "random", Long.valueOf(Instant.now().toEpochMilli()));
        this.oAuthTokenCache.setCurrentToken((OAuthBearerToken)token1);
        Assert.assertEquals((Object)false, (Object)this.oAuthTokenCache.isTokenExpired());
        Thread.sleep(10L);
        Assert.assertEquals((Object)false, (Object)this.oAuthTokenCache.isTokenExpired());
    }

    @Test
    public void TestIsExpiredWithExpiredCache() throws InterruptedException {
        Long lifespanSeconds = 2L;
        BasicOAuthBearerToken token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), Instant.now().plusSeconds(lifespanSeconds).toEpochMilli(), "random", Long.valueOf(Instant.now().toEpochMilli()));
        this.oAuthTokenCache.setCurrentToken((OAuthBearerToken)token1);
        Thread.sleep((long)Math.floor((float)(1000L * lifespanSeconds) * 0.8f));
        Assert.assertEquals((Object)true, (Object)this.oAuthTokenCache.isTokenExpired());
    }

    @Test
    public void TestCalculateTokenExpiryTime() {
        long tokenStartTimeMs = Instant.now().plusSeconds(-3L).toEpochMilli();
        long tokenExpiryTimeMs = Instant.now().plusSeconds(-1L).toEpochMilli();
        BasicOAuthBearerToken token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), tokenExpiryTimeMs, "random", Long.valueOf(tokenStartTimeMs));
        Assert.assertEquals((long)tokenExpiryTimeMs, (long)this.oAuthTokenCache.calculateTokenExpiryTime((OAuthBearerToken)token1));
        short cacheExpiryBufferSeconds = 5;
        OauthTokenCache oAuthTokenCache = new OauthTokenCache(cacheExpiryBufferSeconds);
        long lifetimeSeconds = 60L;
        tokenStartTimeMs = Instant.now().toEpochMilli();
        tokenExpiryTimeMs = Instant.now().plusSeconds(lifetimeSeconds).toEpochMilli();
        token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), tokenExpiryTimeMs, "random", Long.valueOf(tokenStartTimeMs));
        long expectedCacheExpiryTimeMs = tokenStartTimeMs + (long)(0.8f * (float)(tokenExpiryTimeMs - tokenStartTimeMs));
        Assert.assertEquals((long)expectedCacheExpiryTimeMs, (long)oAuthTokenCache.calculateTokenExpiryTime((OAuthBearerToken)token1));
        lifetimeSeconds = 20L;
        tokenStartTimeMs = Instant.now().toEpochMilli();
        tokenExpiryTimeMs = Instant.now().plusSeconds(lifetimeSeconds).toEpochMilli();
        token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), tokenExpiryTimeMs, "random", Long.valueOf(tokenStartTimeMs));
        expectedCacheExpiryTimeMs = tokenExpiryTimeMs - TimeUnit.MILLISECONDS.convert(cacheExpiryBufferSeconds, TimeUnit.SECONDS);
        Assert.assertEquals((long)expectedCacheExpiryTimeMs, (long)oAuthTokenCache.calculateTokenExpiryTime((OAuthBearerToken)token1));
    }
}

