/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.exceptions.SchemaRegistryOauthTokenRetrieverException;
import java.io.IOException;
import java.util.Collections;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.BasicOAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CachedOauthTokenRetrieverTest {
    @Mock
    AccessTokenRetriever accessTokenRetriever;
    @Mock
    AccessTokenValidator accessTokenValidator;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    OauthTokenCache oauthTokenCache;
    @InjectMocks
    CachedOauthTokenRetriever cachedOauthTokenRetriever = new CachedOauthTokenRetriever();
    private String tokenString1 = "token1";
    private String tokenString2 = "token2";
    private OAuthBearerToken token1;
    private OAuthBearerToken token2;

    @Test
    public void TestGetTokenWithValidCache() throws IOException {
        this.token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), 2000L, "random", Long.valueOf(0L));
        Mockito.when((Object)this.accessTokenRetriever.retrieve()).thenReturn((Object)this.tokenString1);
        Mockito.when((Object)this.accessTokenValidator.validate(this.tokenString1)).thenReturn((Object)this.token1);
        Mockito.when((Object)this.oauthTokenCache.isTokenExpired()).thenReturn((Object)true).thenReturn((Object)false);
        ((OauthTokenCache)Mockito.doNothing().when((Object)this.oauthTokenCache)).setCurrentToken((OAuthBearerToken)Mockito.any(OAuthBearerToken.class));
        Mockito.when((Object)this.oauthTokenCache.getCurrentToken().value()).thenReturn((Object)this.tokenString1);
        Assert.assertEquals((Object)this.tokenString1, (Object)this.cachedOauthTokenRetriever.getToken());
        Assert.assertEquals((Object)this.tokenString1, (Object)this.cachedOauthTokenRetriever.getToken());
        ((AccessTokenValidator)Mockito.verify((Object)this.accessTokenValidator, (VerificationMode)Mockito.times((int)1))).validate(ArgumentMatchers.anyString());
        ((AccessTokenRetriever)Mockito.verify((Object)this.accessTokenRetriever, (VerificationMode)Mockito.times((int)1))).retrieve();
        ((OauthTokenCache)Mockito.verify((Object)this.oauthTokenCache, (VerificationMode)Mockito.times((int)2))).isTokenExpired();
    }

    @Test
    public void TestGetTokenWithExpiredCache() throws IOException, InterruptedException {
        this.token1 = new BasicOAuthBearerToken(this.tokenString1, Collections.emptySet(), 100L, "random", Long.valueOf(0L));
        this.token2 = new BasicOAuthBearerToken(this.tokenString2, Collections.emptySet(), 100L, "random", Long.valueOf(0L));
        Mockito.when((Object)this.accessTokenRetriever.retrieve()).thenReturn((Object)this.tokenString1).thenReturn((Object)this.tokenString2);
        Mockito.when((Object)this.accessTokenValidator.validate(this.tokenString1)).thenReturn((Object)this.token1);
        Mockito.when((Object)this.accessTokenValidator.validate(this.tokenString2)).thenReturn((Object)this.token2);
        Mockito.when((Object)this.oauthTokenCache.isTokenExpired()).thenReturn((Object)true);
        ((OauthTokenCache)Mockito.doNothing().when((Object)this.oauthTokenCache)).setCurrentToken((OAuthBearerToken)Mockito.any(OAuthBearerToken.class));
        Mockito.when((Object)this.oauthTokenCache.getCurrentToken().value()).thenReturn((Object)this.tokenString1).thenReturn((Object)this.tokenString2);
        Assert.assertEquals((Object)this.tokenString1, (Object)this.cachedOauthTokenRetriever.getToken());
        Assert.assertEquals((Object)this.tokenString2, (Object)this.cachedOauthTokenRetriever.getToken());
        ((AccessTokenValidator)Mockito.verify((Object)this.accessTokenValidator, (VerificationMode)Mockito.times((int)2))).validate(ArgumentMatchers.anyString());
        ((AccessTokenRetriever)Mockito.verify((Object)this.accessTokenRetriever, (VerificationMode)Mockito.times((int)2))).retrieve();
        ((OauthTokenCache)Mockito.verify((Object)this.oauthTokenCache, (VerificationMode)Mockito.times((int)2))).isTokenExpired();
    }

    @Test
    public void TestGetTokenThrowsException() throws IOException {
        String ioError = "Returned 401";
        Mockito.when((Object)this.oauthTokenCache.isTokenExpired()).thenReturn((Object)true);
        Mockito.when((Object)this.accessTokenRetriever.retrieve()).thenThrow(new Throwable[]{new IOException(ioError)}).thenReturn((Object)this.tokenString1);
        Assert.assertThrows((String)ioError, SchemaRegistryOauthTokenRetrieverException.class, () -> {
            String token = this.cachedOauthTokenRetriever.getToken();
        });
        String validationError = "Malformed JWT provided";
        Mockito.when((Object)this.accessTokenValidator.validate(this.tokenString1)).thenThrow(new Throwable[]{new ValidateException(validationError)});
        Assert.assertThrows((String)validationError, SchemaRegistryOauthTokenRetrieverException.class, () -> {
            String token = this.cachedOauthTokenRetriever.getToken();
        });
    }
}

