/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tools;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionExecutor;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="register-deks", mixinStandardHelpOptions=true, description={"Register and/or auto-rotate DEKs according to a specified data contract."}, sortOptions=false, sortSynopsis=false)
public class RegisterDeks
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterDeks.class);
    private static final String DEFAULT_RULE_PARAM_PREFIX = "rule.executors._default_.param.";
    @CommandLine.Parameters(index="0", description={"SR (Schema Registry) URL"}, paramLabel="<url>")
    private String baseUrl;
    @CommandLine.Parameters(index="1", description={"Subject"}, paramLabel="<subject>")
    private String subject;
    @CommandLine.Parameters(index="2", arity="0..1", defaultValue="-1", description={"Version, defaults to latest"}, paramLabel="<version>")
    private int version;
    @CommandLine.Option(names={"-X", "--property"}, description={"Set configuration property."}, paramLabel="<prop=val>")
    private Map<String, String> configs;
    private Clock clock;

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    public Integer call() throws Exception {
        HashMap<String, Object> configs = this.configs != null ? new HashMap<String, Object>(this.configs) : new HashMap();
        configs.put("schema.registry.url", this.baseUrl);
        if (this.clock != null) {
            configs.put("clock", (String)((Object)this.clock));
        }
        try (SchemaRegistryClient client = SchemaRegistryClientFactory.newClient(Collections.singletonList(this.baseUrl), (int)1000, (List)ImmutableList.of((Object)new AvroSchemaProvider()), configs, Collections.emptyMap());){
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(client);
            Optional<ParsedSchema> schema = this.parseSchema(schemaMetadata);
            if (!schema.isPresent()) {
                LOG.error("No schema found");
                Integer n = 1;
                return n;
            }
            ParsedSchema parsedSchema = schema.get();
            if (parsedSchema.ruleSet() == null || parsedSchema.ruleSet().getDomainRules() == null) {
                LOG.info("No rules found");
                Integer n = 0;
                return n;
            }
            List rules = parsedSchema.ruleSet().getDomainRules();
            for (int i = 0; i < rules.size(); ++i) {
                Rule rule = (Rule)rules.get(i);
                if (rule.isDisabled() || !"ENCRYPT".equals(rule.getType())) continue;
                this.processRule(configs, parsedSchema, rules, i, rule);
            }
            Integer n = 0;
            return n;
        }
    }

    private SchemaMetadata getSchemaMetadata(SchemaRegistryClient client) throws IOException, RestClientException {
        SchemaMetadata schemaMetadata = this.version >= 0 ? client.getSchemaMetadata(this.subject, this.version) : client.getLatestSchemaMetadata(this.subject);
        return schemaMetadata;
    }

    private void processRule(Map<String, Object> configs, ParsedSchema parsedSchema, List<Rule> rules, int i, Rule rule) throws RuleException, GeneralSecurityException {
        try (FieldEncryptionExecutor executor = new FieldEncryptionExecutor();){
            Map<String, Object> ruleConfigs = this.configsWithoutPrefix(rule, configs);
            executor.configure(ruleConfigs);
            RuleContext ctx = new RuleContext(configs, null, parsedSchema, this.subject, null, null, null, null, false, RuleMode.WRITE, rule, i, rules);
            FieldEncryptionExecutor.FieldEncryptionExecutorTransform transform = executor.newTransform(ctx);
            transform.getOrCreateDek(ctx, transform.isDekRotated() ? Integer.valueOf(-1) : null);
        }
    }

    private Optional<ParsedSchema> parseSchema(SchemaMetadata schemaMetadata) throws Exception {
        AvroSchemaProvider provider;
        switch (schemaMetadata.getSchemaType()) {
            case "AVRO": {
                provider = new AvroSchemaProvider();
                break;
            }
            case "JSON": {
                provider = (SchemaProvider)Class.forName("io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                break;
            }
            case "PROTOBUF": {
                provider = (SchemaProvider)Class.forName("io.confluent.kafka.schemaregistry.json.JsonSchemaProvider").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schema type " + schemaMetadata.getSchemaType());
            }
        }
        return provider.parseSchema(new Schema(null, schemaMetadata), false, false);
    }

    private Map<String, Object> configsWithoutPrefix(Rule rule, Map<String, Object> configs) {
        HashMap<String, Object> ruleConfigs = new HashMap<String, Object>(configs);
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(DEFAULT_RULE_PARAM_PREFIX)) continue;
            ruleConfigs.put(name.substring(DEFAULT_RULE_PARAM_PREFIX.length()), entry.getValue());
        }
        String prefix = "rule.executors." + rule.getName() + ".param.";
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(prefix)) continue;
            ruleConfigs.put(name.substring(prefix.length()), entry.getValue());
        }
        return ruleConfigs;
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new RegisterDeks());
        commandLine.setUsageHelpLongOptionsMaxWidth(30);
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }
}

