/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.DekRegistryClientFactory;
import io.confluent.dekregistry.client.MockDekRegistryClientFactory;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import io.confluent.kafka.schemaregistry.encryption.local.LocalFieldEncryptionProperties;
import io.confluent.kafka.schemaregistry.encryption.tools.RegisterDeks;
import io.confluent.kafka.schemaregistry.testutil.FakeClock;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import picocli.CommandLine;

public class RegisterDeksTest {
    private final FieldEncryptionProperties fieldEncryptionProps;
    private final SchemaRegistryClient schemaRegistry;
    private final DekRegistryClient dekRegistry;
    private final String topic;
    private final FakeClock fakeClock = new FakeClock();

    public RegisterDeksTest() throws Exception {
        this.topic = "test";
        this.fieldEncryptionProps = new LocalFieldEncryptionProperties((List<String>)ImmutableList.of((Object)"rule1"));
        this.schemaRegistry = SchemaRegistryClientFactory.newClient(Collections.singletonList("mock://"), (int)1000, (List)ImmutableList.of((Object)new AvroSchemaProvider()), null, null);
        this.dekRegistry = DekRegistryClientFactory.newClient(Collections.singletonList("mock://"), (int)1000, (int)100000, Collections.emptyMap(), null);
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII\", \"PII3\"]},{\"name\": \"name2\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII2\"]},{\"name\": \"age\", \"type\": [\"null\", \"int\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    @After
    public void tearDown() {
        MockSchemaRegistry.clear();
        MockDekRegistryClientFactory.clear();
    }

    @Test
    public void testRegisterDek() throws Exception {
        String subject = this.topic + "-value";
        String kekName = "kek1";
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata(kekName);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(subject, (ParsedSchema)avroSchema);
        RegisterDeks app = new RegisterDeks();
        CommandLine cmd = new CommandLine((Object)app);
        int exitCode = cmd.execute(new String[]{"mock://", subject, "--property", "rule.executors._default_.param.secret=mysecret"});
        Assert.assertEquals((long)0L, (long)exitCode);
        Dek dek = this.dekRegistry.getDekVersion(kekName, subject, -1, null, false);
        Assert.assertEquals((Object)kekName, (Object)dek.getKekName());
    }

    @Test
    public void testRotateDek() throws Exception {
        String subject = this.topic + "rotate-value";
        String kekName = "kek2";
        AvroSchema avroSchema = new AvroSchema(this.createUserSchema());
        Rule rule = new Rule("rule1", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1"), null, null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata(kekName);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(subject, (ParsedSchema)avroSchema);
        RegisterDeks app = new RegisterDeks();
        app.setClock((Clock)this.fakeClock);
        CommandLine cmd = new CommandLine((Object)app);
        int exitCode = cmd.execute(new String[]{"mock://", subject, "--property", "rule.executors._default_.param.secret=mysecret"});
        Assert.assertEquals((long)0L, (long)exitCode);
        Dek dek = this.dekRegistry.getDekVersion(kekName, subject, -1, null, false);
        Assert.assertEquals((Object)kekName, (Object)dek.getKekName());
        Assert.assertEquals((long)1L, (long)dek.getVersion());
        exitCode = cmd.execute(new String[]{"mock://", subject, "--property", "rule.executors._default_.param.secret=mysecret"});
        Assert.assertEquals((long)0L, (long)exitCode);
        dek = this.dekRegistry.getDekVersion(kekName, subject, -1, null, false);
        Assert.assertEquals((Object)kekName, (Object)dek.getKekName());
        Assert.assertEquals((long)1L, (long)dek.getVersion());
        this.fakeClock.advance(2L, ChronoUnit.DAYS);
        exitCode = cmd.execute(new String[]{"mock://", subject, "--property", "rule.executors._default_.param.secret=mysecret"});
        Assert.assertEquals((long)0L, (long)exitCode);
        dek = this.dekRegistry.getDekVersion(kekName, subject, -1, null, false);
        Assert.assertEquals((Object)kekName, (Object)dek.getKekName());
        Assert.assertEquals((long)2L, (long)dek.getVersion());
    }

    protected Metadata getMetadata(String kekName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", kekName);
        properties.put("encrypt.kms.type", this.fieldEncryptionProps.getKmsType());
        properties.put("encrypt.kms.key.id", this.fieldEncryptionProps.getKmsKeyId());
        return this.getMetadata(properties);
    }

    protected Metadata getMetadata(Map<String, String> properties) {
        return new Metadata(Collections.emptyMap(), properties, Collections.emptySet());
    }
}

