/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public interface KmsDriver {
    public static final String KMS_TYPE_SUFFIX = "://";
    public static final String TEST_CLIENT = "test.client";

    public String getKeyUrlPrefix();

    public KmsClient newKmsClient(Map<String, ?> var1, Optional<String> var2) throws GeneralSecurityException;

    default public boolean doesSupport(String keyUri) {
        return keyUri.toLowerCase(Locale.US).startsWith(this.getKeyUrlPrefix());
    }

    default public KmsClient getKmsClient(String kekUrl) throws GeneralSecurityException {
        return KmsClients.get((String)kekUrl);
    }

    default public KmsClient registerKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        KmsClient client = this.newKmsClient(configs, kekUrl);
        KmsClients.add((KmsClient)client);
        return client;
    }

    default public Object getTestClient(Map<String, ?> configs) {
        return configs.get(TEST_CLIENT);
    }
}

