/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.TinkProtoParametersFormat;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.daead.DeterministicAeadConfig;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.nio.BufferUnderflowException;
import java.security.GeneralSecurityException;

public class Cryptor {
    private final DekFormat dekFormat;
    private final KeyTemplate dekTemplate;

    public Cryptor(DekFormat dekFormat) throws GeneralSecurityException {
        try {
            this.dekFormat = dekFormat;
            this.dekTemplate = KeyTemplate.parseFrom((byte[])TinkProtoParametersFormat.serialize((Parameters)dekFormat.getParameters()), (ExtensionRegistryLite)ExtensionRegistryLite.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public DekFormat getDekFormat() {
        return this.dekFormat;
    }

    public byte[] generateKey() throws GeneralSecurityException {
        return Registry.newKeyData((KeyTemplate)this.dekTemplate).getValue().toByteArray();
    }

    public byte[] encrypt(byte[] dek, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        byte[] ciphertext;
        if (this.dekFormat.isDeterministic()) {
            DeterministicAead aead = (DeterministicAead)Registry.getPrimitive((String)this.dekTemplate.getTypeUrl(), (byte[])dek, DeterministicAead.class);
            ciphertext = aead.encryptDeterministically(plaintext, associatedData);
        } else {
            Aead aead = (Aead)Registry.getPrimitive((String)this.dekTemplate.getTypeUrl(), (byte[])dek, Aead.class);
            ciphertext = aead.encrypt(plaintext, associatedData);
        }
        return ciphertext;
    }

    public byte[] decrypt(byte[] dek, byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            if (this.dekFormat.isDeterministic()) {
                DeterministicAead aead = (DeterministicAead)Registry.getPrimitive((String)this.dekTemplate.getTypeUrl(), (byte[])dek, DeterministicAead.class);
                return aead.decryptDeterministically(ciphertext, associatedData);
            }
            Aead aead = (Aead)Registry.getPrimitive((String)this.dekTemplate.getTypeUrl(), (byte[])dek, Aead.class);
            return aead.decrypt(ciphertext, associatedData);
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | BufferUnderflowException e) {
            throw new GeneralSecurityException("invalid ciphertext", e);
        }
    }

    static {
        try {
            AeadConfig.register();
            DeterministicAeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

