/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.daead.DeterministicAeadConfig;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class KmsDriverManager {
    private static final List<KmsDriver> drivers;

    private KmsDriverManager() {
    }

    public static KmsDriver getDriver(String keyUri) throws GeneralSecurityException {
        for (KmsDriver driver : drivers) {
            if (!driver.doesSupport(keyUri)) continue;
            return driver;
        }
        throw new GeneralSecurityException("No KMS driver supports: " + keyUri);
    }

    private static List<KmsDriver> loadDrivers() {
        ArrayList<KmsDriver> drivers = new ArrayList<KmsDriver>();
        ServiceLoader<KmsDriver> clientLoader = ServiceLoader.load(KmsDriver.class);
        for (KmsDriver element : clientLoader) {
            drivers.add(element);
        }
        return Collections.unmodifiableList(drivers);
    }

    static {
        try {
            AeadConfig.register();
            DeterministicAeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        drivers = KmsDriverManager.loadDrivers();
    }
}

