/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.hcvault;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionExecutor;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HcVaultFieldEncryptionProperties
extends FieldEncryptionProperties {
    public HcVaultFieldEncryptionProperties(List<String> ruleNames) {
        super(ruleNames);
    }

    public HcVaultFieldEncryptionProperties(List<String> ruleNames, Class<?> ruleExecutor) {
        super(ruleNames, ruleExecutor);
    }

    public String getKmsType() {
        return "hcvault";
    }

    public String getKmsKeyId() {
        return "http://127.0.0.1:8200/transit/keys/my-key";
    }

    public Map<String, Object> getClientProperties(String baseUrls) throws Exception {
        List ruleNames = this.getRuleNames();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("schema.registry.url", baseUrls);
        props.put("auto.register.schemas", "false");
        props.put("use.latest.version", "true");
        props.put("latest.cache.ttl.sec", "60");
        props.put("rule.executors", String.join((CharSequence)",", ruleNames));
        for (String ruleName : ruleNames) {
            props.put("rule.executors." + ruleName + ".class", this.getRuleExecutor().getName());
            props.put("rule.executors." + ruleName + ".param." + "token.id", "dev-only-token");
            props.put("rule.executors." + ruleName + ".param." + "test.client", this.getTestClient());
        }
        return props;
    }

    public Object getTestClient() throws Exception {
        return HcVaultFieldEncryptionProperties.mockClient(this.getKmsKeyId());
    }

    static Logical mockClient(String keyId) throws Exception {
        Aead aead = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES128_GCM")).getPrimitive(Aead.class);
        HashMap response = new HashMap();
        LogicalResponse logicalResponse = (LogicalResponse)Mockito.mock(LogicalResponse.class);
        Mockito.when((Object)logicalResponse.getData()).thenReturn(response);
        Logical logical = (Logical)Mockito.mock(Logical.class);
        Mockito.when((Object)logical.write((String)ArgumentMatchers.any(String.class), (Map)ArgumentMatchers.any(Map.class))).thenAnswer(invocationOnMock -> {
            String path = (String)invocationOnMock.getArgument(0);
            Map request = (Map)invocationOnMock.getArgument(1);
            if (request.containsKey("plaintext")) {
                byte[] plaintext = Base64.getDecoder().decode((String)request.get("plaintext"));
                byte[] ciphertext = aead.encrypt(plaintext, FieldEncryptionExecutor.EMPTY_AAD);
                response.put("ciphertext", Base64.getEncoder().encodeToString(ciphertext));
            } else {
                byte[] ciphertext = Base64.getDecoder().decode((String)request.get("ciphertext"));
                byte[] plaintext = aead.decrypt(ciphertext, FieldEncryptionExecutor.EMPTY_AAD);
                response.put("plaintext", Base64.getEncoder().encodeToString(plaintext));
            }
            return logicalResponse;
        });
        return logical;
    }
}

