/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.azure;

import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionExecutor;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AzureFieldEncryptionProperties
extends FieldEncryptionProperties {
    public AzureFieldEncryptionProperties(List<String> ruleNames) {
        super(ruleNames);
    }

    public AzureFieldEncryptionProperties(List<String> ruleNames, Class<?> ruleExecutor) {
        super(ruleNames, ruleExecutor);
    }

    public String getKmsType() {
        return "azure-kms";
    }

    public String getKmsKeyId() {
        return "https://yokota1.vault.azure.net/keys/key1/1234567890";
    }

    public Map<String, Object> getClientProperties(String baseUrls) throws Exception {
        List ruleNames = this.getRuleNames();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("schema.registry.url", baseUrls);
        props.put("auto.register.schemas", "false");
        props.put("use.latest.version", "true");
        props.put("latest.cache.ttl.sec", "60");
        props.put("rule.executors", String.join((CharSequence)",", ruleNames));
        for (String ruleName : ruleNames) {
            props.put("rule.executors." + ruleName + ".class", this.getRuleExecutor().getName());
            props.put("rule.executors." + ruleName + ".param." + "test.client", this.getTestClient());
        }
        return props;
    }

    public Object getTestClient() throws Exception {
        return AzureFieldEncryptionProperties.mockClient(this.getKmsKeyId());
    }

    static CryptographyClient mockClient(String keyId) throws Exception {
        Aead aead = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES128_GCM")).getPrimitive(Aead.class);
        CryptographyClient client = (CryptographyClient)Mockito.mock(CryptographyClient.class);
        Mockito.when((Object)client.encrypt((EncryptionAlgorithm)ArgumentMatchers.any(EncryptionAlgorithm.class), (byte[])ArgumentMatchers.any(byte[].class))).thenAnswer(invocationOnMock -> {
            EncryptionAlgorithm algo = (EncryptionAlgorithm)invocationOnMock.getArgument(0);
            byte[] plainText = (byte[])invocationOnMock.getArgument(1);
            byte[] ciphertext = aead.encrypt(plainText, FieldEncryptionExecutor.EMPTY_AAD);
            return new EncryptResult(ciphertext, algo, keyId);
        });
        Mockito.when((Object)client.decrypt((EncryptionAlgorithm)ArgumentMatchers.any(EncryptionAlgorithm.class), (byte[])ArgumentMatchers.any(byte[].class))).thenAnswer(invocationOnMock -> {
            EncryptionAlgorithm algo = (EncryptionAlgorithm)invocationOnMock.getArgument(0);
            byte[] ciphertext = (byte[])invocationOnMock.getArgument(1);
            byte[] plaintext = aead.decrypt(ciphertext, FieldEncryptionExecutor.EMPTY_AAD);
            return new DecryptResult(plaintext, algo, keyId);
        });
        return client;
    }
}

