/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kms.AbstractAWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FakeAwsKms
extends AbstractAWSKMS {
    private final Map<String, Aead> aeads = new HashMap<String, Aead>();

    private static byte[] serializeContext(Map<String, String> encryptionContext) {
        TreeMap<String, String> ordered = new TreeMap<String, String>(encryptionContext);
        return ordered.toString().getBytes(StandardCharsets.UTF_8);
    }

    public FakeAwsKms(List<String> validKeyIds) throws GeneralSecurityException {
        for (String keyId : validKeyIds) {
            Aead aead = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES128_GCM")).getPrimitive(Aead.class);
            this.aeads.put(keyId, aead);
        }
    }

    public EncryptResult encrypt(EncryptRequest request) {
        if (!this.aeads.containsKey(request.getKeyId())) {
            throw new AmazonServiceException("Unknown key ID : " + request.getKeyId() + " is not in " + this.aeads.keySet());
        }
        try {
            Aead aead = this.aeads.get(request.getKeyId());
            byte[] ciphertext = aead.encrypt(request.getPlaintext().array(), FakeAwsKms.serializeContext(request.getEncryptionContext()));
            return new EncryptResult().withKeyId(request.getKeyId()).withCiphertextBlob(ByteBuffer.wrap(ciphertext));
        }
        catch (GeneralSecurityException e) {
            throw new AmazonServiceException(e.getMessage());
        }
    }

    public DecryptResult decrypt(DecryptRequest request) {
        for (Map.Entry<String, Aead> entry : this.aeads.entrySet()) {
            try {
                byte[] plaintext = entry.getValue().decrypt(request.getCiphertextBlob().array(), FakeAwsKms.serializeContext(request.getEncryptionContext()));
                return new DecryptResult().withKeyId(entry.getKey()).withPlaintext(ByteBuffer.wrap(plaintext));
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        throw new AmazonServiceException("unable to decrypt");
    }
}

