/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import io.confluent.kafka.schemaregistry.encryption.aws.FakeAwsKms;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AwsFieldEncryptionProperties
extends FieldEncryptionProperties {
    public AwsFieldEncryptionProperties(List<String> ruleNames) {
        super(ruleNames);
    }

    public AwsFieldEncryptionProperties(List<String> ruleNames, Class<?> ruleExecutor) {
        super(ruleNames, ruleExecutor);
    }

    public String getKmsType() {
        return "aws-kms";
    }

    public String getKmsKeyId() {
        return "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab";
    }

    public Map<String, Object> getClientProperties(String baseUrls) throws Exception {
        List ruleNames = this.getRuleNames();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("schema.registry.url", baseUrls);
        props.put("auto.register.schemas", "false");
        props.put("use.latest.version", "true");
        props.put("latest.cache.ttl.sec", "60");
        props.put("rule.executors", String.join((CharSequence)",", ruleNames));
        for (String ruleName : ruleNames) {
            props.put("rule.executors." + ruleName + ".class", this.getRuleExecutor().getName());
            props.put("rule.executors." + ruleName + ".param." + "test.client", this.getTestClient());
        }
        return props;
    }

    public Object getTestClient() throws Exception {
        return new FakeAwsKms(Collections.singletonList(this.getKmsKeyId()));
    }
}

