/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.ResourceLoader;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SchemaDiffTest {
    private static final String badMessageSchemaString = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestBadMessage {\n    bad.Message test_bad_message = 1;\n}\n";
    private static final ProtobufSchema badMessageSchema = new ProtobufSchema("syntax = \"proto3\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestMapProtos\";\n\nimport \"google/protobuf/descriptor.proto\";\n\nmessage TestBadMessage {\n    bad.Message test_bad_message = 1;\n}\n");

    @Test
    public void checkProtobufSchemaCompatibility() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode nodes = (ArrayNode)objectMapper.readTree(SchemaDiffTest.readFile("diff-schema-examples.json"));
        this.checkProtobufSchemaCompatibility(nodes);
    }

    @Test
    public void checkProtobufSchemaCompatibilityForMeta() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode nodes = (ArrayNode)objectMapper.readTree(SchemaDiffTest.readFile("diff-schema-examples-with-meta.json"));
        this.checkProtobufSchemaCompatibility(nodes);
    }

    private void checkProtobufSchemaCompatibility(ArrayNode nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            ObjectNode testCase = (ObjectNode)nodes.get(i);
            String originalSchema = testCase.get("original_schema").asText();
            String updateSchema = testCase.get("update_schema").asText();
            ProtoFileElement original = this.getSchema(originalSchema);
            ProtoFileElement update = this.getSchema(updateSchema);
            ArrayList<SchemaReference> originalSchemaRefs = new ArrayList<SchemaReference>();
            ArrayNode originalRefs = (ArrayNode)testCase.get("original_references");
            if (originalRefs != null) {
                for (JsonNode ref : originalRefs) {
                    ObjectNode node = (ObjectNode)ref;
                    SchemaReference schemaRef = new SchemaReference(node.get("name").asText(), node.get("subject").asText(), Integer.valueOf(node.get("version").asInt()));
                    originalSchemaRefs.add(schemaRef);
                }
            }
            ArrayList<SchemaReference> updateSchemaRefs = new ArrayList<SchemaReference>();
            ArrayNode updateRefs = (ArrayNode)testCase.get("update_references");
            if (updateRefs != null) {
                for (JsonNode ref : updateRefs) {
                    ObjectNode node = (ObjectNode)ref;
                    SchemaReference schemaRef = new SchemaReference(node.get("name").asText(), node.get("subject").asText(), Integer.valueOf(node.get("version").asInt()));
                    updateSchemaRefs.add(schemaRef);
                }
            }
            HashMap<String, ProtoFileElement> originalDependencies = new HashMap<String, ProtoFileElement>();
            ArrayNode originalDeps = (ArrayNode)testCase.get("original_dependencies");
            if (originalDeps != null) {
                for (JsonNode dep : originalDeps) {
                    ObjectNode node = (ObjectNode)dep;
                    ProtoFileElement file = this.getDependency(node);
                    originalDependencies.put(node.get("name").asText(), file);
                }
            }
            HashMap<String, ProtoFileElement> updateDependencies = new HashMap<String, ProtoFileElement>();
            ArrayNode updateDeps = (ArrayNode)testCase.get("update_dependencies");
            if (updateDeps != null) {
                for (JsonNode dep : updateDeps) {
                    ObjectNode node = (ObjectNode)dep;
                    ProtoFileElement file = this.getDependency(node);
                    updateDependencies.put(node.get("name").asText(), file);
                }
            }
            ArrayNode changes = (ArrayNode)testCase.get("changes");
            boolean isCompatible = testCase.get("compatible").asBoolean();
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (int j = 0; j < changes.size(); ++j) {
                errorMessages.add(changes.get(j).asText());
            }
            String description = testCase.get("description").asText();
            ProtobufSchema o = new ProtobufSchema(original, originalSchemaRefs, originalDependencies);
            o = o.copy(this.getMetadata(testCase, "original"), null);
            ProtobufSchema u = new ProtobufSchema(update, updateSchemaRefs, updateDependencies);
            u = u.copy(this.getMetadata(testCase, "update"), null);
            List differences = SchemaDiff.compare((ProtobufSchema)o, (ProtobufSchema)u);
            List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains(diff.getType())).collect(Collectors.toList());
            MatcherAssert.assertThat((String)description, differences.stream().map(change -> change.getType().toString() + " " + change.getFullPath()).collect(Collectors.toList()), (Matcher)CoreMatchers.is(errorMessages));
            Assert.assertEquals((String)description, (Object)isCompatible, (Object)incompatibleDiffs.isEmpty());
        }
    }

    private Metadata getMetadata(ObjectNode testCase, String version) {
        ObjectMapper mapper = new ObjectMapper();
        switch (version) {
            case "original": {
                if (!testCase.has("original_metadata")) break;
                return (Metadata)mapper.convertValue((Object)testCase.get("original_metadata"), Metadata.class);
            }
            case "update": {
                if (!testCase.has("update_metadata")) break;
                return (Metadata)mapper.convertValue((Object)testCase.get("update_metadata"), Metadata.class);
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private ProtoFileElement getSchema(String schema) {
        if (schema.endsWith(".proto")) {
            schema = SchemaDiffTest.readFile(schema);
        }
        return ProtoParser.Companion.parse(Location.get((String)"unknown"), schema);
    }

    private ProtoFileElement getDependency(ObjectNode node) {
        String name = node.get("name").asText();
        JsonNode dep = node.get("dependency");
        String schema = dep != null ? dep.asText() : SchemaDiffTest.readFile(name);
        return ProtoParser.Companion.parse(Location.get((String)"unknown"), schema);
    }

    @Test
    public void checkCompatibilityUsingProtoFiles() throws Exception {
        ResourceLoader resourceLoader = new ResourceLoader("/io/confluent/kafka/schemaregistry/protobuf/diff/");
        ProtoFileElement original = resourceLoader.readObj("TestProto.proto");
        ProtoFileElement update = resourceLoader.readObj("TestProto2.proto");
        List changes = SchemaDiff.compare((ProtobufSchema)new ProtobufSchema(original, Collections.emptyList(), Collections.emptyMap()), (ProtobufSchema)new ProtobufSchema(update, Collections.emptyList(), Collections.emptyMap()));
        Assert.assertTrue((boolean)changes.contains(new Difference(Difference.Type.FIELD_NAME_CHANGED, "#/TestMessage/2")));
        Assert.assertTrue((boolean)changes.contains(new Difference(Difference.Type.FIELD_SCALAR_KIND_CHANGED, "#/TestMessage/2")));
    }

    @Test
    public void checkCompatibilityUsingBadMessage() throws Exception {
        SchemaDiff.compare((ProtobufSchema)badMessageSchema, (ProtobufSchema)badMessageSchema);
    }

    private static String readFile(String fileName) {
        ResourceLoader resourceLoader = new ResourceLoader("/");
        return resourceLoader.toString(fileName);
    }
}

