/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.confluent.kafka.schemaregistry.json.jackson.JSONArrayDeserializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JSONObject ob = new JSONObject();
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            block17: {
                String fieldName = p.getCurrentName();
                t = p.nextToken();
                try {
                    switch (t) {
                        case START_ARRAY: {
                            ob.put(fieldName, (Object)JSONArrayDeserializer.instance.deserialize(p, ctxt));
                            break block17;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, (Object)this.deserialize(p, ctxt));
                            break block17;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, (Object)p.getText());
                            break block17;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block17;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, (Object)Boolean.TRUE);
                            break block17;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, (Object)Boolean.FALSE);
                            break block17;
                        }
                        case VALUE_NUMBER_INT: {
                            Number num = p.getNumberValue();
                            if (num instanceof Byte || num instanceof Short) {
                                num = num.intValue();
                            }
                            ob.put(fieldName, (Object)num);
                            break block17;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, (Object)p.getNumberValue());
                            break block17;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            Object o = p.getEmbeddedObject();
                            if (o instanceof byte[]) {
                                o = p.getText();
                            }
                            ob.put(fieldName, o);
                            break block17;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.instantiationException(this.handledType(), (Throwable)e);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
            t = p.nextToken();
        }
        return ob;
    }
}

