/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.example.ExtendedUser;
import io.confluent.kafka.example.ExtendedWidget;
import io.confluent.kafka.example.Grant;
import io.confluent.kafka.example.Widget;
import io.confluent.kafka.example.annotated.User;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroDecoder;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import kafka.utils.VerifiableProperties;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Test;

public class KafkaAvroSerializerTest {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaAvroSerializer reflectionAvroSerializer;
    private final KafkaAvroDecoder avroDecoder;
    private final String topic;
    private final KafkaAvroDeserializer specificAvroDeserializer;
    private final KafkaAvroDecoder specificAvroDecoder;
    private final KafkaAvroDeserializer reflectionAvroDeserializer;
    private final KafkaAvroDecoder reflectionAvroDecoder;
    private static final Schema arraySchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"array\",\n \"name\": \"test\",\n \"items\": {\n\"type\": \"record\",\n\"namespace\": \"example.avro\",\n\"name\": \"User\",\n\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}}");
    private static final Schema mapSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"map\",\n \"name\": \"test\",\n \"values\": {\n\"type\": \"record\",\n\"namespace\": \"example.avro\",\n\"name\": \"User\",\n\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}}");

    public KafkaAvroSerializerTest() {
        Properties defaultConfig = new Properties();
        defaultConfig.put("schema.registry.url", "bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(defaultConfig));
        this.avroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry);
        this.avroDecoder = new KafkaAvroDecoder(this.schemaRegistry, new VerifiableProperties(defaultConfig));
        this.topic = "test";
        HashMap<String, String> specificDeserializerProps = new HashMap<String, String>();
        specificDeserializerProps.put("schema.registry.url", "bogus");
        specificDeserializerProps.put("specific.avro.reader", "true");
        this.specificAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, specificDeserializerProps);
        Properties specificDecoderProps = new Properties();
        specificDecoderProps.setProperty("schema.registry.url", "bogus");
        specificDecoderProps.setProperty("specific.avro.reader", "true");
        this.specificAvroDecoder = new KafkaAvroDecoder(this.schemaRegistry, new VerifiableProperties(specificDecoderProps));
        HashMap<String, String> reflectionProps = new HashMap<String, String>();
        reflectionProps.put("schema.registry.url", "bogus");
        reflectionProps.put("schema.reflection", "true");
        this.reflectionAvroSerializer = new KafkaAvroSerializer(this.schemaRegistry, reflectionProps);
        this.reflectionAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, reflectionProps);
        Properties reflectionDecoderProps = new Properties();
        reflectionDecoderProps.setProperty("schema.registry.url", "bogus");
        reflectionDecoderProps.setProperty("schema.reflection", "true");
        reflectionDecoderProps.setProperty("avro.reflection.allow.null", "true");
        reflectionDecoderProps.setProperty("avro.use.logical.type.converters", "true");
        this.reflectionAvroDecoder = new KafkaAvroDecoder(this.schemaRegistry, new VerifiableProperties(reflectionDecoderProps));
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createUserRecord() {
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private Schema createExtendUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}, {\"name\": \"age\", \"type\": [\"null\", \"int\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createExtendUserRecordWithNullField() {
        Schema schema = this.createExtendUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private IndexedRecord createExtendUserRecord() {
        Schema schema = this.createExtendUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        avroRecord.put("age", (Object)30);
        return avroRecord;
    }

    private IndexedRecord createUserRecordUtf8() {
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)new Utf8("testUser"));
        return avroRecord;
    }

    private Schema createAccountSchema() {
        String accountSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"Account\",\"fields\": [{\"name\": \"accountNumber\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(accountSchema);
        return schema;
    }

    private IndexedRecord createAccountRecord() {
        return this.createAccountRecord("0123456789");
    }

    private IndexedRecord createAccountRecord(String accountNumber) {
        Schema schema = this.createAccountSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("accountNumber", (Object)accountNumber);
        return avroRecord;
    }

    private Schema createBalanceSchema() {
        String balanceSchema = "{\n\t\"namespace\": \"example.avro\", \"type\": \"record\",\n    \"name\": \"Account\",\n    \"fields\": [\n    \t{\"name\": \"accountNumber\", \"type\": \"string\"},\n        {\"name\": \"balance\", \"type\": {\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},\n        {\"name\": \"date\", \"type\": {\"type\":\"int\",\"logicalType\":\"date\"}},\n        {\"name\": \"timeMs\", \"type\": {\"type\":\"int\",\"logicalType\":\"time-millis\"}},\n        {\"name\": \"timeMicros\", \"type\": {\"type\":\"long\",\"logicalType\":\"time-micros\"}},\n        {\"name\": \"tsMs\", \"type\": {\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},\n        {\"name\": \"tsMicros\", \"type\": {\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},\n        {\"name\": \"localTsMs\", \"type\": {\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},\n        {\"name\": \"localTsMicros\", \"type\": {\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}}\n    ]\n}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(balanceSchema);
        return schema;
    }

    private IndexedRecord createBalanceRecord() {
        Schema schema = this.createBalanceSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("accountNumber", (Object)"0123456789");
        avroRecord.put("balance", (Object)new BigDecimal("10.00"));
        avroRecord.put("date", (Object)LocalDate.of(2021, 1, 1));
        avroRecord.put("timeMs", (Object)LocalTime.of(1, 1, 1, 1000000));
        avroRecord.put("timeMicros", (Object)LocalTime.of(1, 1, 1, 1001000));
        avroRecord.put("tsMs", (Object)Instant.ofEpochMilli(1613646696368L));
        avroRecord.put("tsMicros", (Object)Instant.ofEpochMilli(1613646696368009L));
        avroRecord.put("localTsMs", (Object)LocalDateTime.of(2021, 1, 1, 1, 1, 1, 1000000));
        avroRecord.put("localTsMicros", (Object)LocalDateTime.of(2021, 1, 1, 1, 1, 1, 1001000));
        return avroRecord;
    }

    private IndexedRecord createSpecificAvroRecord() {
        return io.confluent.kafka.example.User.newBuilder().setName("testUser").build();
    }

    private IndexedRecord createExtendedSpecificAvroRecord() {
        return ExtendedUser.newBuilder().setName("testUser").setAge(99).setUpdatedAt(Instant.ofEpochMilli(1613646696368L)).build();
    }

    private IndexedRecord createAnnotatedUserRecord() {
        return User.newBuilder().setName("testUser").build();
    }

    private IndexedRecord createInvalidAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"f1\", \"type\": \"string\"},{\"name\": \"f2\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("f1", (Object)"value1");
        avroRecord.put("f1", (Object)12);
        return avroRecord;
    }

    @Test
    public void testKafkaAvroSerializer() {
        IndexedRecord avroRecord = this.createUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
        IndexedRecord avroRecordWithAllField = this.createExtendUserRecord();
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecordWithAllField);
        Assert.assertEquals((Object)avroRecordWithAllField, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecordWithAllField, (Object)this.avroDecoder.fromBytes(bytes));
        IndexedRecord avroRecordWithoutOptional = this.createExtendUserRecordWithNullField();
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecordWithoutOptional);
        Assert.assertEquals((Object)avroRecordWithoutOptional, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecordWithoutOptional, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals(null, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)true);
        Assert.assertEquals((Object)true, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)true, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)123);
        Assert.assertEquals((Object)123, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)123, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)345L);
        Assert.assertEquals((Object)345L, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)345L, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)Float.valueOf(1.23f));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)Float.valueOf(1.23f), (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)2.34);
        Assert.assertEquals((Object)2.34, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)2.34, (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)"abc", (Object)this.avroDecoder.fromBytes(bytes));
        bytes = this.avroSerializer.serialize(this.topic, (Object)"abc".getBytes());
        Assert.assertArrayEquals((byte[])"abc".getBytes(), (byte[])((byte[])this.avroDeserializer.deserialize(this.topic, bytes)));
        Assert.assertArrayEquals((byte[])"abc".getBytes(), (byte[])((byte[])this.avroDecoder.fromBytes(bytes)));
        bytes = this.avroSerializer.serialize(this.topic, (Object)new Utf8("abc"));
        Assert.assertEquals((Object)"abc", (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)"abc", (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerWithoutAutoRegister() {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.avroSerializer.serialize(this.topic, (Object)avroRecord);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaAvroSerializerWithoutConfigure() {
        KafkaAvroSerializer unconfiguredSerializer = new KafkaAvroSerializer();
        IndexedRecord avroRecord = this.createUserRecord();
        unconfiguredSerializer.serialize(this.topic, (Object)avroRecord);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testKafkaAvroDeserializerWithoutConfigure() {
        KafkaAvroDeserializer unconfiguredSerializer = new KafkaAvroDeserializer();
        byte[] randomBytes = "foo".getBytes();
        unconfiguredSerializer.deserialize(this.topic, randomBytes);
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegistered() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegisteredUseSchemaId() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.schema.id", (Object)1);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerWithPreRegisteredUseSchemaIdIncompatibleError() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.schema.id", (Object)2);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegisteredUseSchemaIdIncompatibleNoError() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.schema.id", (Object)2, (Object)"id.compatibility.strict", (Object)false);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        IndexedRecord badRecord = this.createAccountRecord("testUser");
        Assert.assertEquals((Object)badRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)badRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegisteredUseLatest() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegisteredUseLatestAndNormalize() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true, (Object)"normalize.schemas", (Object)true);
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord avroRecord = this.createUserRecord();
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(avroRecord.getSchema()));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithPreRegisteredRemoveJavaProperties() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"avro.remove.java.properties", (Object)true);
        this.avroSerializer.configure((Map)configs, false);
        String schema = "{\n  \"namespace\": \"io.confluent.kafka.example.annotated\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    }\n  ]\n}";
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(schema));
        IndexedRecord annotatedUserRecord = this.createAnnotatedUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)annotatedUserRecord);
        Assert.assertEquals((Object)annotatedUserRecord, (Object)this.specificAvroDeserializer.deserialize(this.topic, bytes));
        Assert.assertEquals((Object)annotatedUserRecord, (Object)this.specificAvroDecoder.fromBytes(bytes));
    }

    @Test
    public void testKafkaAvroSerializerWithMultiType() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"value.subject.name.strategy", (Object)TopicRecordNameStrategy.class.getName());
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord record1 = this.createUserRecord();
        IndexedRecord record2 = this.createAccountRecord();
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record1);
        byte[] bytes2 = this.avroSerializer.serialize(this.topic, (Object)record2);
        Assert.assertNotNull((Object)this.schemaRegistry.getLatestSchemaMetadata(this.topic + "-example.avro.User"));
        Assert.assertNotNull((Object)this.schemaRegistry.getLatestSchemaMetadata(this.topic + "-example.avro.Account"));
        Assert.assertEquals((Object)record1, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
        Assert.assertEquals((Object)record2, (Object)this.avroDeserializer.deserialize(this.topic, bytes2));
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerWithMultiTypeError() {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"value.subject.name.strategy", (Object)TopicRecordNameStrategy.class.getName());
        this.avroSerializer.configure((Map)configs, false);
        this.avroSerializer.serialize(this.topic, (Object)"a string should not be allowed");
    }

    @Test
    public void testKafkaAvroSerializerWithMultiTypeUnion() throws IOException, RestClientException {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        this.schemaRegistry.register("user", (ParsedSchema)new AvroSchema(this.createUserSchema()));
        this.schemaRegistry.register("account", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema("[ \"example.avro.User\", \"example.avro.Account\" ]", (List)ImmutableList.of((Object)new SchemaReference("example.avro.User", "user", Integer.valueOf(1)), (Object)new SchemaReference("example.avro.Account", "account", Integer.valueOf(1))), (Map)ImmutableMap.of((Object)"example.avro.User", (Object)this.createUserSchema().toString(), (Object)"example.avro.Account", (Object)this.createAccountSchema().toString()), null));
        this.avroSerializer.configure((Map)configs, false);
        IndexedRecord record1 = this.createUserRecord();
        IndexedRecord record2 = this.createAccountRecord();
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record1);
        byte[] bytes2 = this.avroSerializer.serialize(this.topic, (Object)record2);
        Assert.assertEquals((Object)record1, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
        Assert.assertEquals((Object)record2, (Object)this.avroDeserializer.deserialize(this.topic, bytes2));
    }

    @Test
    public void testKafkaAvroSerializerWithMultiTypeUnionSpecific() throws IOException, RestClientException {
        ImmutableMap serializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        ImmutableMap deserializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"specific.avro.reader", (Object)true);
        IndexedRecord record = this.createSpecificAvroRecord();
        AvroSchema schema = new AvroSchema(record.getSchema());
        this.schemaRegistry.register("user", (ParsedSchema)schema);
        this.schemaRegistry.register("account", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema("[ \"io.confluent.kafka.example.User\", \"example.avro.Account\" ]", (List)ImmutableList.of((Object)new SchemaReference("io.confluent.kafka.example.User", "user", Integer.valueOf(1)), (Object)new SchemaReference("example.avro.Account", "account", Integer.valueOf(1))), (Map)ImmutableMap.of((Object)"io.confluent.kafka.example.User", (Object)schema.toString(), (Object)"example.avro.Account", (Object)this.createAccountSchema().toString()), null));
        this.avroSerializer.configure((Map)serializerConfigs, false);
        this.avroDeserializer.configure((Map)deserializerConfigs, false);
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record);
        Assert.assertEquals((Object)record, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
    }

    @Test
    public void testKafkaAvroSerializerWithMultiTypeUnionSpecificAndMultipleTopics() throws IOException, RestClientException {
        ImmutableMap serializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        ImmutableMap deserializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"specific.avro.reader", (Object)true);
        String differentTopic = "another_topic";
        IndexedRecord record = this.createSpecificAvroRecord();
        AvroSchema schema = new AvroSchema(record.getSchema());
        Grant grantRecord = Grant.newBuilder().setGrant("p234").build();
        AvroSchema grantSchema = new AvroSchema(grantRecord.getSchema());
        this.schemaRegistry.register("user", (ParsedSchema)schema);
        this.schemaRegistry.register("account", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema("[ \"io.confluent.kafka.example.User\", \"example.avro.Account\" ]", (List)ImmutableList.of((Object)new SchemaReference("io.confluent.kafka.example.User", "user", Integer.valueOf(1)), (Object)new SchemaReference("example.avro.Account", "account", Integer.valueOf(1))), (Map)ImmutableMap.of((Object)"io.confluent.kafka.example.User", (Object)schema.toString(), (Object)"example.avro.Account", (Object)this.createAccountSchema().toString()), null));
        this.schemaRegistry.register("grant", (ParsedSchema)grantSchema);
        this.schemaRegistry.register(differentTopic + "-value", (ParsedSchema)new AvroSchema("[ \"io.confluent.kafka.example.Grant\" ]", (List)ImmutableList.of((Object)new SchemaReference("io.confluent.kafka.example.Grant", "grant", Integer.valueOf(1))), (Map)ImmutableMap.of((Object)"io.confluent.kafka.example.User", (Object)schema.toString(), (Object)"example.avro.Account", (Object)this.createAccountSchema().toString(), (Object)"io.confluent.kafka.example.Grant", (Object)grantSchema.toString()), null));
        this.avroSerializer.configure((Map)serializerConfigs, false);
        this.avroDeserializer.configure((Map)deserializerConfigs, false);
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record);
        byte[] bytesGrant = this.avroSerializer.serialize(differentTopic, (Object)grantRecord);
        Assert.assertEquals((Object)record, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
        Assert.assertEquals((Object)((Object)grantRecord), (Object)this.avroDeserializer.deserialize(differentTopic, bytesGrant));
    }

    @Test
    public void testKafkaAvroSerializerWithCyclicReference() throws IOException, RestClientException {
        IndexedRecord record = this.createSpecificAvroRecord();
        AvroSchema schema = new AvroSchema(record.getSchema());
        this.schemaRegistry.register("user", (ParsedSchema)schema);
        this.schemaRegistry.register("account", (ParsedSchema)new AvroSchema(this.createAccountSchema().toString(), (List)ImmutableList.of((Object)new SchemaReference("io.confluent.kafka.example.User", "user", Integer.valueOf(-1))), (Map)ImmutableMap.of((Object)"io.confluent.kafka.example.User", (Object)schema.toString()), null));
        this.schemaRegistry.register("user", (ParsedSchema)new AvroSchema(schema.toString(), (List)ImmutableList.of((Object)new SchemaReference("example.avro.Account", "account", Integer.valueOf(-1))), (Map)ImmutableMap.of((Object)"example.avro.Account", (Object)this.createAccountSchema().toString()), null));
        Assert.assertNotNull((Object)this.schemaRegistry.parseSchema("AVRO", this.createAccountSchema().toString(), (List)ImmutableList.of((Object)new SchemaReference("io.confluent.kafka.example.User", "user", Integer.valueOf(-1)))));
    }

    @Test
    public void testKafkaAvroSerializerWithArraySpecific() throws IOException, RestClientException {
        ImmutableMap serializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        ImmutableMap deserializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"specific.avro.reader", (Object)true);
        IndexedRecord record1 = this.createUserRecordUtf8();
        GenericData.Array data = new GenericData.Array(arraySchema, Arrays.asList(record1));
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(arraySchema));
        this.avroSerializer.configure((Map)serializerConfigs, false);
        this.avroDeserializer.configure((Map)deserializerConfigs, false);
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)data);
        Object result = this.avroDeserializer.deserialize(this.topic, bytes1);
        Assert.assertEquals((Object)data, (Object)result);
    }

    @Test
    public void testKafkaAvroSerializerWithMapSpecific() throws IOException, RestClientException {
        ImmutableMap serializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"auto.register.schemas", (Object)false, (Object)"use.latest.version", (Object)true);
        ImmutableMap deserializerConfigs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"specific.avro.reader", (Object)true);
        HashMap<Utf8, IndexedRecord> data = new HashMap<Utf8, IndexedRecord>();
        data.put(new Utf8("one"), this.createUserRecordUtf8());
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema(mapSchema));
        this.avroSerializer.configure((Map)serializerConfigs, false);
        this.avroDeserializer.configure((Map)deserializerConfigs, false);
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, data);
        Object result = this.avroDeserializer.deserialize(this.topic, bytes1);
        Assert.assertEquals(data, (Object)result);
    }

    @Test
    public void testKafkaAvroSerializerWithProjection() {
        IndexedRecord avroRecord = this.createExtendedSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.avroDecoder.fromBytes(bytes);
        GenericData.Record extendedUser = (GenericData.Record)obj;
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        Assert.assertNotNull((Object)extendedUser.get("age"));
        obj = this.avroDecoder.fromBytes(bytes, io.confluent.kafka.example.User.getClassSchema());
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        GenericData.Record decoderProjection = (GenericData.Record)obj;
        Assert.assertEquals((Object)"testUser", (Object)decoderProjection.get("name").toString());
        try {
            decoderProjection.get("age");
            Assert.fail((String)"Getting invalid schema field should fail");
        }
        catch (AvroRuntimeException avroRuntimeException) {
            // empty catch block
        }
        obj = this.avroDeserializer.deserialize(this.topic, bytes, io.confluent.kafka.example.User.getClassSchema());
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        GenericData.Record deserializeProjection = (GenericData.Record)obj;
        Assert.assertEquals((Object)"testUser", (Object)deserializeProjection.get("name").toString());
        try {
            deserializeProjection.get("age");
            Assert.fail((String)"Getting invalid schema field should fail");
        }
        catch (AvroRuntimeException avroRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testKafkaAvroSerializerSupportsSchemaEvolution() throws IOException, RestClientException {
        String fieldToDelete = "fieldToDelete";
        String newOptionalField = "newOptionalField";
        Schema schemaV1 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"SchemaEvolution").namespace("example.avro")).fields().requiredString("fieldToDelete").endRecord();
        Schema schemaV2 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"SchemaEvolution").namespace("example.avro")).fields().nullableString("newOptionalField", "optional").endRecord();
        AvroSchema avroSchemaV1 = new AvroSchema(schemaV1);
        AvroSchema avroSchemaV2 = new AvroSchema(schemaV2);
        Assert.assertTrue((String)"Schema V2 should be backwards compatible", (boolean)avroSchemaV2.isBackwardCompatible((ParsedSchema)avroSchemaV1).isEmpty());
        GenericData.Record recordV1 = new GenericData.Record(avroSchemaV1.rawSchema());
        recordV1.put("fieldToDelete", (Object)"present");
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)recordV1);
        GenericRecord genericRecordV2 = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes, avroSchemaV2.rawSchema());
        Assert.assertNotNull((String)"Optional field should have a non-null default value", (Object)genericRecordV2.get("newOptionalField"));
        try {
            genericRecordV2.get("fieldToDelete");
            Assert.fail((String)"Getting invalid schema field should fail");
        }
        catch (AvroRuntimeException avroRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecord() {
        IndexedRecord avroRecord = this.createSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.avroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a GenericData Record", (boolean)GenericData.Record.class.isInstance(obj));
        obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.User", (boolean)io.confluent.kafka.example.User.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.User", (boolean)io.confluent.kafka.example.User.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecordWithProjection() {
        IndexedRecord avroRecord = this.createExtendedSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedUser", (boolean)ExtendedUser.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDecoder.fromBytes(bytes, io.confluent.kafka.example.User.getClassSchema());
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.User", (boolean)io.confluent.kafka.example.User.class.isInstance(obj));
        Assert.assertEquals((Object)"testUser", (Object)((io.confluent.kafka.example.User)((Object)obj)).getName().toString());
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedUser", (boolean)ExtendedUser.class.isInstance(obj));
        Assert.assertEquals((Object)avroRecord, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes, io.confluent.kafka.example.User.getClassSchema());
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.User", (boolean)io.confluent.kafka.example.User.class.isInstance(obj));
        Assert.assertEquals((Object)"testUser", (Object)((io.confluent.kafka.example.User)((Object)obj)).getName().toString());
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecordWithValueTypeConfig() {
        HashMap<String, String> specificDeserializerProps = new HashMap<String, String>();
        specificDeserializerProps.put("schema.registry.url", "bogus");
        specificDeserializerProps.put("specific.avro.reader", "true");
        specificDeserializerProps.put("specific.avro.value.type", io.confluent.kafka.example.User.class.getName());
        KafkaAvroDeserializer specificAvroDeserializerWithReaderSchema = new KafkaAvroDeserializer(this.schemaRegistry, specificDeserializerProps);
        IndexedRecord avroRecord = this.createExtendedSpecificAvroRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Object obj = specificAvroDeserializerWithReaderSchema.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.User", (boolean)io.confluent.kafka.example.User.class.isInstance(obj));
        Assert.assertEquals((Object)"testUser", (Object)((io.confluent.kafka.example.User)((Object)obj)).getName().toString());
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecord() {
        Widget widget = new Widget("alice");
        Schema schema = ReflectData.get().getSchema(widget.getClass());
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDecoder.fromBytes(bytes, schema);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.Widget", (boolean)Widget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.Widget", (boolean)Widget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecordWithNullField() {
        ExtendedWidget widget = new ExtendedWidget();
        widget.setName("alice");
        Schema schema = ReflectData.AllowNull.get().getSchema(widget.getClass());
        try {
            this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
            Assert.fail((String)"Sending instance with null field should fail reflection serializer");
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"schema.reflection", (Object)true, (Object)"avro.reflection.allow.null", (Object)true);
        this.reflectionAvroDeserializer.configure((Map)configs, false);
        this.reflectionAvroSerializer.configure((Map)configs, false);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDecoder.fromBytes(bytes, schema);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.ExtendedWidget", (boolean)ExtendedWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a io.confluent.kafka.example.ExtendedWidget", (boolean)ExtendedWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecordWithLogicalType() {
        RecordWithUUID record = new RecordWithUUID();
        record.uuid = UUID.randomUUID();
        Schema schema = AvroSchemaUtils.getReflectData().getSchema(record.getClass());
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"schema.reflection", (Object)true, (Object)"avro.use.logical.type.converters", (Object)true);
        this.reflectionAvroDeserializer.configure((Map)configs, false);
        this.reflectionAvroSerializer.configure((Map)configs, false);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)record);
        Object obj = this.reflectionAvroDecoder.fromBytes(bytes, schema);
        Assert.assertTrue((String)"Returned object should be a RecordWithUUID", (boolean)RecordWithUUID.class.isInstance(obj));
        Assert.assertEquals((Object)record, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a RecordWithUUID", (boolean)RecordWithUUID.class.isInstance(obj));
        Assert.assertEquals((Object)record, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecordWithLogicalTypeNullField() {
        RecordWithUUID record = new RecordWithUUID();
        Schema schema = AvroSchemaUtils.getReflectDataAllowNull().getSchema(record.getClass());
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"schema.reflection", (Object)true, (Object)"avro.reflection.allow.null", (Object)true, (Object)"avro.use.logical.type.converters", (Object)true);
        this.reflectionAvroDeserializer.configure((Map)configs, false);
        this.reflectionAvroSerializer.configure((Map)configs, false);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)record);
        Object obj = this.reflectionAvroDecoder.fromBytes(bytes, schema);
        Assert.assertTrue((String)"Returned object should be a RecordWithUUID", (boolean)RecordWithUUID.class.isInstance(obj));
        Assert.assertEquals((Object)record, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a RecordWithUUID", (boolean)RecordWithUUID.class.isInstance(obj));
        Assert.assertEquals((Object)record, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecordWithProjection() {
        ExtendedWidget widget = new ExtendedWidget("alice", 20);
        Schema extendedWidgetSchema = ReflectData.get().getSchema(ExtendedWidget.class);
        Schema widgetSchema = ReflectData.get().getSchema(Widget.class);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDecoder.fromBytes(bytes, extendedWidgetSchema);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedWidget", (boolean)ExtendedWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        obj = this.reflectionAvroDecoder.fromBytes(bytes, widgetSchema);
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.Widget", (boolean)Widget.class.isInstance(obj));
        Assert.assertEquals((Object)"alice", (Object)((Widget)obj).getName());
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, extendedWidgetSchema);
        Assert.assertTrue((String)"Full object should be a io.confluent.kafka.example.ExtendedWidget", (boolean)ExtendedWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, widgetSchema);
        Assert.assertTrue((String)"Projection object should be a io.confluent.kafka.example.Widget", (boolean)Widget.class.isInstance(obj));
        Assert.assertEquals((Object)"alice", (Object)((Widget)obj).getName());
    }

    @Test
    public void testKafkaAvroSerializerNonexistantReflectionRecord() {
        IndexedRecord avroRecord = this.createUserRecord();
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        try {
            this.specificAvroDecoder.fromBytes(bytes);
            Assert.fail((String)"Did not throw an exception when class for specific avro record does not exist.");
        }
        catch (SerializationException serializationException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Threw the incorrect exception when class for specific avro record does not exist.");
        }
        try {
            this.specificAvroDeserializer.deserialize(this.topic, bytes);
            Assert.fail((String)"Did not throw an exception when class for specific avro record does not exist.");
        }
        catch (SerializationException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Threw the incorrect exception when class for specific avro record does not exist.");
        }
    }

    @Test
    public void testNull() {
        SchemaRegistryClient nullSchemaRegistryClient = null;
        KafkaAvroSerializer nullAvroSerializer = new KafkaAvroSerializer(nullSchemaRegistryClient);
        Assert.assertEquals(null, (Object)nullAvroSerializer.serialize("test", null));
    }

    @Test
    public void testAvroSerializerInvalidInput() {
        IndexedRecord invalidRecord = this.createInvalidAvroRecord();
        try {
            this.avroSerializer.serialize(this.topic, (Object)invalidRecord);
            Assert.fail((String)"Sending invalid record should fail serializer");
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    @Test
    public void test_schemas_per_subject() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("schema.registry.url", "bogus");
        props.put("specific.avro.reader", "true");
        props.put("max.schemas.per.subject", "5");
        this.avroSerializer.configure(props, false);
    }

    @Test
    public void testKafkaAvroSerializerSpecificRecordWithPrimitives() {
        String message = "testKafkaAvroSerializerSpecificRecordWithPrimitives";
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)message);
        Object obj = this.avroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        obj = this.specificAvroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
        obj = this.specificAvroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionRecordWithPrimitives() {
        String message = "testKafkaAvroSerializerReflectionRecordWithPrimitives";
        Schema schema = AvroSchemaUtils.getSchema((Object)message);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)message);
        Object obj = this.avroDecoder.fromBytes(bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
        obj = this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
        obj = this.reflectionAvroDecoder.fromBytes(bytes, schema);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
        obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object should be a String", (boolean)String.class.isInstance(obj));
        Assert.assertEquals((Object)message, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerGenericRecordWithConverters() {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"bogus", (Object)"value.subject.name.strategy", (Object)TopicRecordNameStrategy.class.getName(), (Object)"avro.use.logical.type.converters", (Object)true);
        this.avroSerializer.configure((Map)configs, false);
        this.avroDeserializer.configure((Map)configs, false);
        IndexedRecord record1 = this.createBalanceRecord();
        byte[] bytes1 = this.avroSerializer.serialize(this.topic, (Object)record1);
        Assert.assertEquals((Object)record1, (Object)this.avroDeserializer.deserialize(this.topic, bytes1));
    }

    @Test
    public void testResolvedFormat() throws IOException, RestClientException {
        this.schemaRegistry.register("user", (ParsedSchema)new AvroSchema(this.createUserSchema()));
        this.schemaRegistry.register("account", (ParsedSchema)new AvroSchema(this.createAccountSchema()));
        int id = this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)new AvroSchema("[ \"example.avro.User\", \"example.avro.Account\" ]", (List)ImmutableList.of((Object)new SchemaReference("example.avro.User", "user", Integer.valueOf(1)), (Object)new SchemaReference("example.avro.Account", "account", Integer.valueOf(1))), (Map)ImmutableMap.of((Object)"example.avro.User", (Object)this.createUserSchema().toString(), (Object)"example.avro.Account", (Object)this.createAccountSchema().toString()), null));
        AvroSchema schema = (AvroSchema)this.schemaRegistry.getSchemaById(id);
        String expectedCanonical = "[\"example.avro.User\",\"example.avro.Account\"]";
        Assert.assertEquals((Object)expectedCanonical, (Object)schema.canonicalString());
        String expectedResolved = "[{\"type\":\"record\",\"name\":\"User\",\"namespace\":\"example.avro\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"}]},{\"type\":\"record\",\"name\":\"Account\",\"namespace\":\"example.avro\",\"fields\":[{\"name\":\"accountNumber\",\"type\":\"string\"}]}]";
        Assert.assertEquals((Object)expectedResolved, (Object)schema.formattedString(AvroSchema.Format.RESOLVED.symbol()));
    }

    static class RecordWithUUID {
        UUID uuid;

        RecordWithUUID() {
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RecordWithUUID)) {
                return false;
            }
            RecordWithUUID that = (RecordWithUUID)obj;
            return Objects.equals(this.uuid, that.uuid);
        }
    }
}

