/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.dekregistry.client.rest.entities.KeyType;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataEncryptionKeyId.class, name="DEK"), @JsonSubTypes.Type(value=KeyEncryptionKeyId.class, name="KEK")})
public abstract class EncryptionKeyId
implements Comparable<EncryptionKeyId> {
    private final String tenant;
    private final KeyType type;

    @JsonCreator
    public EncryptionKeyId(@JsonProperty(value="tenant") String tenant, @JsonProperty(value="type") KeyType type) {
        this.tenant = tenant;
        this.type = type;
    }

    @JsonProperty(value="tenant")
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="type")
    public KeyType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionKeyId that = (EncryptionKeyId)o;
        return Objects.equals(this.tenant, that.tenant) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.tenant, this.type);
    }

    @Override
    public int compareTo(EncryptionKeyId that) {
        if (this.tenant != null || that.tenant != null) {
            if (this.tenant == null) {
                return -1;
            }
            if (that.tenant == null) {
                return 1;
            }
            int tenantComparison = this.tenant.compareTo(that.tenant);
            if (tenantComparison != 0) {
                return tenantComparison < 0 ? -1 : 1;
            }
        }
        if (this.type == null && that.type == null) {
            return 0;
        }
        if (this.type == null) {
            return -1;
        }
        if (that.type == null) {
            return 1;
        }
        return this.type.compareTo((Enum)that.type);
    }
}

