/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.testutil;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.annotation.Nullable;

public final class TestKmsClient
implements KmsClient {
    public static final String PREFIX = "test-kms://";
    private static final String AES_GCM_KEY = "type.googleapis.com/google.crypto.tink.AesGcmKey";
    @Nullable
    private String keyUri;
    private Aead aead;

    private TestKmsClient() {
    }

    public TestKmsClient(String uri, String secret) throws GeneralSecurityException {
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must start with test-kms://");
        }
        this.keyUri = uri;
        PrimitiveSet.Builder builder = PrimitiveSet.newBuilder(Aead.class);
        builder.addPrimaryPrimitive((Object)this.getPrimitive(secret), this.getKey(secret));
        this.aead = (Aead)Registry.wrap((PrimitiveSet)builder.build());
    }

    private Aead getPrimitive(String secret) throws GeneralSecurityException {
        byte[] keyBytes = Hkdf.computeHkdf((String)"HmacSha256", (byte[])secret.getBytes(StandardCharsets.UTF_8), null, null, (int)16);
        AesGcmKey key = AesGcmKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])keyBytes)).build();
        return (Aead)Registry.getPrimitive((String)AES_GCM_KEY, (ByteString)key.toByteString(), Aead.class);
    }

    private Keyset.Key getKey(String secret) throws GeneralSecurityException {
        return Keyset.Key.newBuilder().setKeyId(this.getId(secret)).setStatus(KeyStatusType.ENABLED).setOutputPrefixType(OutputPrefixType.TINK).build();
    }

    private int getId(String secret) throws GeneralSecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(secret.getBytes(StandardCharsets.UTF_8));
            return ByteBuffer.wrap(md.digest()).getInt();
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        return this;
    }

    @CanIgnoreReturnValue
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        return this;
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        return this.aead;
    }
}

