/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tests.mortgage;

import com.nvidia.spark.rapids.tests.mortgage.ReadPerformanceCsv$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class AggregatesWithPercentiles$ {
    public static AggregatesWithPercentiles$ MODULE$;

    static {
        new AggregatesWithPercentiles$();
    }

    public Dataset<Row> csv(SparkSession spark, String mortgagePerformance) {
        Dataset<Row> dfp = ReadPerformanceCsv$.MODULE$.apply(spark, mortgagePerformance);
        Dataset kindOfAnon = dfp.withColumn("loan_id_hash", functions$.MODULE$.hex(functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("loan_id")})))).drop("loan_id");
        kindOfAnon.createOrReplaceTempView("perf_data");
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        select r.loan_id_hash,\n          round(min(r.interest_rate), 4) as interest_rate_min,\n          round(max(r.interest_rate), 4) as interest_rate_max,\n          round(avg(r.interest_rate), 4) as interest_rate_avg,\n          round(percentile(r.interest_rate, 0.5), 4) as interest_rate_50p,\n          round(percentile(r.interest_rate, 0.75), 4) as interest_rate_75p,\n          round(percentile(r.interest_rate, 0.90), 4) as interest_rate_90p,\n          round(percentile(r.interest_rate, 0.99), 4) as interest_rate_99p\n        from perf_data r\n         group by r.loan_id_hash\n      ")).stripMargin());
    }

    private AggregatesWithPercentiles$() {
        MODULE$ = this;
    }
}

