/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AwsV4Signer {
    private static final Logger LOG = LogManager.getLogger(AwsV4Signer.class);
    public static final ZoneId UTC = ZoneId.of("Z");
    public static final DateTimeFormatter AMZ_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'", Locale.US).withZone(UTC);
    public static final DateTimeFormatter SIGNER_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.US).withZone(UTC);
    private static final Set<String> IGNORED_HEADERS = ImmutableSet.of((Object)"accept-encoding", (Object)"authorization", (Object)"user-agent");
    private Request request;
    private String contentSha256;
    private ZonedDateTime date;
    private String region;
    private String accessKey;
    private String secretKey;
    private String prevSignature;
    private String scope;
    private Map<String, String> canonicalHeaders;
    private String signedHeaders;
    private HttpUrl url;
    private String canonicalQueryString;
    private String canonicalRequest;
    private String canonicalRequestHash;
    private String stringToSign;
    private byte[] signingKey;
    private String signature;
    private String authorization;

    private AwsV4Signer(Request request, String contentSha256, ZonedDateTime date, String region, String accessKey, String secretKey, String prevSignature) {
        this.request = request;
        this.contentSha256 = contentSha256;
        this.date = date;
        this.region = region;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.prevSignature = prevSignature;
    }

    public static String sha256Hash(byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest sha256Digest = MessageDigest.getInstance("SHA-256");
        sha256Digest.update(data, 0, length);
        return BaseEncoding.base16().encode(sha256Digest.digest()).toLowerCase(Locale.US);
    }

    public static String sha256Hash(String string) throws NoSuchAlgorithmException {
        byte[] data = string.getBytes(StandardCharsets.UTF_8);
        return AwsV4Signer.sha256Hash(data, data.length);
    }

    private void setScope(String serviceName) {
        this.scope = this.date.format(SIGNER_DATE_FORMAT) + "/" + this.region + "/" + serviceName + "/aws4_request";
    }

    private void setCanonicalHeaders(Set<String> ignored_headers) {
        this.canonicalHeaders = new TreeMap<String, String>();
        Headers headers = this.request.headers();
        for (String name : headers.names()) {
            String signedHeader = name.toLowerCase(Locale.US);
            if (ignored_headers.contains(signedHeader)) continue;
            this.canonicalHeaders.put(signedHeader, headers.values(name).stream().map(value -> value.replaceAll("( +)", " ")).collect(Collectors.joining(",")));
        }
        this.signedHeaders = Joiner.on((String)";").join(this.canonicalHeaders.keySet());
    }

    private void setCanonicalQueryString() {
        String encodedQuery = this.url.encodedQuery();
        if (encodedQuery == null) {
            this.canonicalQueryString = "";
            return;
        }
        ListMultimap signedQueryParams = MultimapBuilder.treeKeys().arrayListValues().build();
        for (String queryParam : encodedQuery.split("&")) {
            String[] tokens = queryParam.split("=");
            if (tokens.length > 1) {
                signedQueryParams.put((Object)tokens[0], (Object)tokens[1]);
                continue;
            }
            signedQueryParams.put((Object)tokens[0], (Object)"");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList al = new ArrayList(signedQueryParams.entries());
        for (Map.Entry entry : al) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String kv = key + "=" + val;
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(kv);
        }
        this.canonicalQueryString = sb.toString();
    }

    private void setCanonicalRequest() throws NoSuchAlgorithmException {
        this.setCanonicalHeaders(IGNORED_HEADERS);
        this.url = this.request.url();
        this.setCanonicalQueryString();
        this.canonicalRequest = this.request.method() + "\n" + this.url.encodedPath() + "\n" + this.canonicalQueryString + "\n" + Joiner.on((String)"\n").withKeyValueSeparator(":").join(this.canonicalHeaders) + "\n\n" + this.signedHeaders + "\n" + this.contentSha256;
        this.canonicalRequestHash = AwsV4Signer.sha256Hash(this.canonicalRequest);
    }

    private void setStringToSign() {
        this.stringToSign = "AWS4-HMAC-SHA256\n" + this.date.format(AMZ_DATE_FORMAT) + "\n" + this.scope + "\n" + this.canonicalRequestHash;
    }

    private void setChunkStringToSign() throws NoSuchAlgorithmException {
        this.stringToSign = "AWS4-HMAC-SHA256-PAYLOAD\n" + this.date.format(AMZ_DATE_FORMAT) + "\n" + this.scope + "\n" + this.prevSignature + "\n" + AwsV4Signer.sha256Hash("") + "\n" + this.contentSha256;
    }

    private void setSigningKey(String serviceName) throws NoSuchAlgorithmException, InvalidKeyException {
        String aws4SecretKey = "AWS4" + this.secretKey;
        byte[] dateKey = AwsV4Signer.sumHmac(aws4SecretKey.getBytes(StandardCharsets.UTF_8), this.date.format(SIGNER_DATE_FORMAT).getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionKey = AwsV4Signer.sumHmac(dateKey, this.region.getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionServiceKey = AwsV4Signer.sumHmac(dateRegionKey, serviceName.getBytes(StandardCharsets.UTF_8));
        this.signingKey = AwsV4Signer.sumHmac(dateRegionServiceKey, "aws4_request".getBytes(StandardCharsets.UTF_8));
    }

    private void setSignature() throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] digest = AwsV4Signer.sumHmac(this.signingKey, this.stringToSign.getBytes(StandardCharsets.UTF_8));
        this.signature = BaseEncoding.base16().encode(digest).toLowerCase(Locale.US);
    }

    private void setAuthorization() {
        this.authorization = "AWS4-HMAC-SHA256 Credential=" + this.accessKey + "/" + this.scope + ", SignedHeaders=" + this.signedHeaders + ", Signature=" + this.signature;
    }

    public static String getChunkSignature(String chunkSha256, ZonedDateTime date, String region, String secretKey, String prevSignature) throws NoSuchAlgorithmException, InvalidKeyException {
        AwsV4Signer signer = new AwsV4Signer(null, chunkSha256, date, region, null, secretKey, prevSignature);
        signer.setScope("s3");
        signer.setChunkStringToSign();
        signer.setSigningKey("s3");
        signer.setSignature();
        return signer.signature;
    }

    private static Request signV4(String serviceName, Request request, String region, String accessKey, String secretKey, String contentSha256) throws NoSuchAlgorithmException, InvalidKeyException {
        ZonedDateTime date = ZonedDateTime.parse(request.header("x-amz-date"), AMZ_DATE_FORMAT);
        AwsV4Signer signer = new AwsV4Signer(request, contentSha256, date, region, accessKey, secretKey, null);
        signer.setScope(serviceName);
        signer.setCanonicalRequest();
        signer.setStringToSign();
        signer.setSigningKey(serviceName);
        signer.setSignature();
        signer.setAuthorization();
        return request.newBuilder().header("Authorization", signer.authorization).build();
    }

    public static Request signV4Service(String serviceName, Request request, String region, String accessKey, String secretKey, String contentSha256) throws NoSuchAlgorithmException, InvalidKeyException {
        return AwsV4Signer.signV4(serviceName, request, region, accessKey, secretKey, contentSha256);
    }

    public static Request signV4S3(Request request, String region, String accessKey, String secretKey, String contentSha256) throws NoSuchAlgorithmException, InvalidKeyException {
        return AwsV4Signer.signV4("s3", request, region, accessKey, secretKey, contentSha256);
    }

    public static Request signV4Sts(Request request, String region, String accessKey, String secretKey, String contentSha256) throws NoSuchAlgorithmException, InvalidKeyException {
        return AwsV4Signer.signV4("sts", request, region, accessKey, secretKey, contentSha256);
    }

    public static String credential(String accessKey, ZonedDateTime date, String region) {
        return accessKey + "/" + date.format(SIGNER_DATE_FORMAT) + "/" + region + "/s3/aws4_request";
    }

    public static String postPresignV4(String stringToSign, String secretKey, ZonedDateTime date, String region) throws NoSuchAlgorithmException, InvalidKeyException {
        AwsV4Signer signer = new AwsV4Signer(null, null, date, region, null, secretKey, null);
        signer.stringToSign = stringToSign;
        signer.setSigningKey("s3");
        signer.setSignature();
        return signer.signature;
    }

    public static byte[] sumHmac(byte[] key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "HmacSHA256"));
        mac.update(data);
        return mac.doFinal();
    }
}

