/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import com.mapr.log4j.MaprfsLogAppender;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.TimeZone;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class MaprfsDailyRollingLogAppender
extends MaprfsLogAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private int maxBackupIndex = 1;
    private long nextCheck = System.currentTimeMillis() - 1L;
    final Date now = new Date();
    SimpleDateFormat sdf;
    final RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    private final Runnable fileDeleteRunnable = new FileDeleteThread();
    private final Thread filesDeletionThread = new Thread(this.fileDeleteRunnable, "Deletion Thread");

    public MaprfsDailyRollingLogAppender() {
    }

    public MaprfsDailyRollingLogAppender(URI uri, String datePattern) {
        super(uri);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    @Override
    public void activateOptions() {
        super.activateOptions();
        if (this.maprFS == null) {
            return;
        }
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            this.filesDeletionThread.setDaemon(true);
            this.filesDeletionThread.start();
            try {
                FileStatus fileStatus = this.maprFS.getFileStatus(this.fileNamePath);
                if (fileStatus != null) {
                    long lastModified = fileStatus.getModificationTime();
                    this.scheduledFilename = this.fileName + this.sdf.format(lastModified);
                }
            }
            catch (IOException e) {
                LogLog.error((String)"IOException while trying to get FileStatus for maprfs", (Throwable)e);
                e.printStackTrace();
            }
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected void append(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException e) {
                LogLog.error((String)("Could not write to: " + this.fileNamePath + ". Failing over to local logging"), (Throwable)e);
                this.failoverToLocalLogs(e);
                return;
            }
            catch (Throwable t) {
                LogLog.error((String)"Fatal error while trying to write to maprfs. Failing over to local logging", (Throwable)t);
                this.failoverToLocalLogs(t);
                return;
            }
        }
        super.append(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollOver() throws IOException {
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        Path newFileNamePath = new Path(new Path(DIR_PREFIX, this.nameHierarchy), this.scheduledFilename);
        if (this.maprFS.exists(newFileNamePath)) {
            LogLog.warn((String)(newFileNamePath + " path exists. Removing it"));
            this.maprFS.delete(newFileNamePath, true);
        }
        if (result = this.maprFS.rename(this.fileNamePath, newFileNamePath)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.createFile(this.fileNamePath);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
        Runnable runnable = this.fileDeleteRunnable;
        synchronized (runnable) {
            this.fileDeleteRunnable.notify();
        }
    }

    class FileDeleteThread
    implements Runnable {
        FileDeleteThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                FileDeleteThread fileDeleteThread = this;
                synchronized (fileDeleteThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LogLog.error((String)"Interrupted Exception during wait for extra files deletion", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                try {
                    FileStatus[] fileStatuses = MaprfsDailyRollingLogAppender.this.maprFS.listStatus(new Path(MaprfsLogAppender.DIR_PREFIX, MaprfsDailyRollingLogAppender.this.nameHierarchy), new PathFilter(){

                        public boolean accept(Path path) {
                            return path.toString().contains(MaprfsDailyRollingLogAppender.this.fileName);
                        }
                    });
                    if (fileStatuses == null || fileStatuses.length < MaprfsDailyRollingLogAppender.this.maxBackupIndex) continue;
                    PriorityQueue<FileStatus> pq = new PriorityQueue<FileStatus>(fileStatuses.length, new Comparator<FileStatus>(){

                        @Override
                        public int compare(FileStatus o1, FileStatus o2) {
                            return Long.signum(o1.getModificationTime() - o2.getModificationTime());
                        }
                    });
                    pq.addAll(Arrays.asList(fileStatuses));
                    int i = 0;
                    while (true) {
                        if (i >= fileStatuses.length - MaprfsDailyRollingLogAppender.this.maxBackupIndex) continue block7;
                        FileStatus fileStatus = pq.poll();
                        MaprfsDailyRollingLogAppender.this.maprFS.delete(fileStatus.getPath(), true);
                        ++i;
                    }
                }
                catch (IOException e) {
                    LogLog.error((String)"IO Exception during extra files removal", (Throwable)e);
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type;

        RollingCalendar() {
            this.type = -1;
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
            this.type = -1;
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

