/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PatternLayoutByLevelWithHeaderTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PatternLayoutByLevelWithHeaderTest.removeLogFile();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    private static void removeLogFile() {
        File logFile = new File("myapp.log");
        if (logFile.exists()) {
            logFile.delete();
        }
    }

    public void loggingTest() throws Exception {
        String line;
        Logger LOG = Logger.getLogger(PatternLayoutByLevelWithHeaderTest.class);
        File logFile = new File("myapp.log");
        if (!logFile.exists()) {
            Assert.fail();
        }
        LOG.info((Object)"Info Message");
        BufferedReader fis = new BufferedReader(new FileReader(logFile));
        int linesCounter = 0;
        boolean isHeaderThere = false;
        boolean isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.startsWith("Header: hostName: ")) {
                isHeaderThere = true;
            }
            if (line.endsWith("INFO  [main] Info Message")) {
                isThere = true;
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertTrue((boolean)isThere);
        Assert.assertTrue((boolean)isHeaderThere);
        Assert.assertEquals((long)2L, (long)linesCounter);
        LOG.debug((Object)"Debug Message");
        fis = new BufferedReader(new FileReader(logFile));
        linesCounter = 0;
        isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.contains("DEBUG [main]") && line.contains("ms since application start") && line.endsWith("Debug Message")) {
                isThere = true;
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertTrue((boolean)isThere);
        Assert.assertEquals((long)3L, (long)linesCounter);
        LOG.trace((Object)"Trace Message");
        fis = new BufferedReader(new FileReader(logFile));
        linesCounter = 0;
        isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.endsWith("Trace Message")) {
                Assert.fail();
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertFalse((boolean)isThere);
        Assert.assertEquals((long)3L, (long)linesCounter);
        LOG.error((Object)"Error Message");
        fis = new BufferedReader(new FileReader(logFile));
        linesCounter = 0;
        isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.contains("ERROR [main]") && line.contains("ms since application start") && line.endsWith("Error Message")) {
                isThere = true;
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertTrue((boolean)isThere);
        Assert.assertEquals((long)4L, (long)linesCounter);
        LOG.fatal((Object)"Fatal message");
        fis = new BufferedReader(new FileReader(logFile));
        linesCounter = 0;
        isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.contains("FATAL [main]") && line.contains("ms since application start") && line.endsWith("Fatal message")) {
                isThere = true;
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertTrue((boolean)isThere);
        Assert.assertEquals((long)5L, (long)linesCounter);
        LOG.warn((Object)"Warn Message");
        fis = new BufferedReader(new FileReader(logFile));
        linesCounter = 0;
        isThere = false;
        while ((line = fis.readLine()) != null) {
            if (line.endsWith("WARN  [main] Warn Message")) {
                isThere = true;
            }
            ++linesCounter;
        }
        fis.close();
        Assert.assertTrue((boolean)isThere);
        Assert.assertEquals((long)6L, (long)linesCounter);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Info message2");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Debug message2");
        }
    }

    @Test
    public void maprfsAppenderTest() throws Exception {
        Logger LOG = Logger.getLogger(PatternLayoutByLevelWithHeaderTest.class);
        for (int i = 0; i < 1000; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
    }

    @Test
    public void maprfsRollingAppendertest() throws Exception {
        PropertyConfigurator.configure((URL)this.getClass().getResource("/log4jrolling.properties"));
        Logger LOG = Logger.getLogger(PatternLayoutByLevelWithHeaderTest.class);
        for (int i = 0; i < 1000; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
    }

    @Test
    public void maprfsDailyRollingAppendertest() throws Exception {
        int i;
        PropertyConfigurator.configure((URL)this.getClass().getResource("/log4jdailyrolling.properties"));
        Logger LOG = Logger.getLogger(PatternLayoutByLevelWithHeaderTest.class);
        for (i = 0; i < 500; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Thread.sleep(120000L);
        for (i = 0; i < 500; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Thread.sleep(120000L);
        for (i = 0; i < 500; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Thread.sleep(120000L);
        for (i = 0; i < 500; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
    }

    @Test
    public void setLogLevelRunTimeTest() throws Exception {
        Logger LOG = Logger.getLogger(PatternLayoutByLevelWithHeaderTest.class);
        for (int i = 0; i < 2; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Logger testLog = Logger.getLogger((String)"com.mapr.log4j.PatternLayoutByLevelWithHeaderTest");
        testLog.setLevel(Level.INFO);
        for (int i = 0; i < 2; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Logger testLog2 = Logger.getLogger((String)"com.mapr.log4j.PatternLayoutByLevelWithHeaderTest");
        testLog2.setLevel(Level.DEBUG);
        for (int i = 0; i < 2; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
        Logger fileClientLog = Logger.getLogger((String)"com.mapr.fs.MapRFsDataOutputStream");
        fileClientLog.setLevel(Level.INFO);
        for (int i = 0; i < 2; ++i) {
            LOG.fatal((Object)("FatalMessage: maprfsAppenderTest " + i));
            LOG.error((Object)("Error message: maprfsAppenderTest " + i));
            LOG.info((Object)("Info message: maprfsAppenderTest " + i));
            LOG.debug((Object)("Debug message: maprfsAppenderTest " + i));
            LOG.trace((Object)("Trace message: maprfsAppenderTest " + i));
        }
    }
}

