/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import com.mapr.security.FipsLoader;
import com.mapr.security.SecurityHelper;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLProbingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(URLProbingUtility.class);
    private static final String BCFKS_FIPS_STORE_TYPE = "bcfks";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "jks";
    private static final SslConfig.SslConfigScope SCOPE_CLIENT_ONLY = SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY;

    private static HttpURLConnection createConnection(URL url) throws Exception {
        String protocol = url.getProtocol();
        if ("http".equalsIgnoreCase(protocol)) {
            return (HttpURLConnection)url.openConnection();
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return URLProbingUtility.createSecureConnection(url);
        }
        throw new IllegalArgumentException("URL has to be either http or https. No other formats are supported");
    }

    private static HttpsURLConnection createSecureConnection(URL url) throws Exception {
        LOG.debug("Creating secure connection to: {}", (Object)url.toString());
        SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(SCOPE_CLIENT_ONLY);
        String trustStoreType = sslConfig.getClientTruststoreType();
        if (trustStoreType == null) {
            trustStoreType = DEFAULT_TRUSTSTORE_TYPE;
        }
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        if (trustStoreType.equals(BCFKS_FIPS_STORE_TYPE)) {
            LOG.debug("Trust store type is BCFKS. Using BC FIPS provider");
            FipsLoader.loadFipsProviders();
            String trustStoreLocation = sslConfig.getClientTruststoreLocation();
            if (trustStoreLocation == null) {
                throw new FileNotFoundException("Missing value for attribute ssl.client.truststore.location");
            }
            char[] truststorePassword = sslConfig.getClientTruststorePassword();
            if (truststorePassword == null && (truststorePassword = SecurityHelper.getPasswordFromCredStore(SecurityHelper.CredStore.CRED_TRUSTSTORE, "ssl.client.truststore.password", trustStoreType, null)) == null) {
                throw new InvalidParameterException("Missing value for attribute ssl.client.truststore.password");
            }
            LOG.debug("Setting trust store at {}", (Object)trustStoreLocation);
            File trustStoreFile = new File(trustStoreLocation);
            KeyStore trustStore = KeyStore.getInstance(trustStoreFile, truststorePassword);
            SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
            LOG.debug("Adding BCJSSE SSL context");
            KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
            keyMgrFact.init(trustStore, truststorePassword);
            TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BCFIPS"));
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
        } else {
            LOG.debug("Using default SSL configuration for non-FIPS mode");
        }
        conn.setHostnameVerifier(new MapRHostnameVerifier());
        return conn;
    }

    public static boolean isURLReachable(String testUrl) {
        try {
            URL url = new URL(testUrl);
            HttpURLConnection connection = URLProbingUtility.createConnection(url);
            connection.setConnectTimeout(15000);
            HttpsURLConnection.setFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Map<String, List<String>> headers;
                if (responseCode >= 300 && responseCode < 400) {
                    String newUrl = connection.getHeaderField("Location");
                    if (newUrl != null) {
                        if (newUrl.equals(testUrl)) {
                            LOG.error("Redirection loop detected. URL redirects to itself.");
                            return false;
                        }
                        return true;
                    }
                } else if (responseCode >= 400 && responseCode < 500 && (headers = connection.getHeaderFields()).containsKey("WWW-Authenticate")) {
                    LOG.warn(testUrl + " requires authentication");
                    return true;
                }
                LOG.error("URL: " + testUrl + " returns invalid code: " + responseCode);
                return false;
            }
        }
        catch (MalformedURLException e) {
            LOG.error("URL: " + testUrl + " is malformed", (Throwable)e);
            return false;
        }
        catch (IOException x) {
            LOG.error("URL: " + testUrl + " can not be reached", (Throwable)x);
            return false;
        }
        catch (Exception e) {
            LOG.error("Unexpected error occurred while checking URL: " + testUrl, (Throwable)e);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        System.out.println(URLProbingUtility.isURLReachable(args[0]));
    }

    private static class MapRHostnameVerifier
    implements HostnameVerifier {
        private MapRHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            try {
                X509Certificate[] chain = (X509Certificate[])session.getPeerCertificates();
                String subject = chain[0].getSubjectX500Principal().getName();
                String issuer = chain[0].getIssuerX500Principal().getName();
                if (chain.length == 1 && issuer.equals(subject)) {
                    LOG.debug("Accepting self signed certificate automatically.");
                    return true;
                }
                if (chain.length == 3 && chain[2].getBasicConstraints() != -1 && issuer.equals(chain[1].getSubjectX500Principal().getName()) && chain[1].getIssuerX500Principal().getName().equals(chain[2].getSubjectX500Principal().getName())) {
                    LOG.debug("Accepting signed certificate automatically.");
                    return true;
                }
                LOG.warn("Peer certificate has failed verification. SubjectDN is: {}", (Object)subject);
                return false;
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.error("Unexpected SSL handshake issue", (Throwable)e);
                return false;
            }
        }
    }
}

