/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapLocks {
    private Map<Integer, RefCount> locksMap = new HashMap<Integer, RefCount>();
    private Lock locksMapLock = new ReentrantLock();
    public static final Logger LOG = LoggerFactory.getLogger(HashMapLocks.class);

    public void lock(int id) {
        this.locksMapLock.lock();
        try {
            RefCount refCount = this.locksMap.get(id);
            if (refCount == null) {
                refCount = new RefCount(this.locksMapLock);
                this.locksMap.put(id, refCount);
            }
            refCount.incrementRefCount();
            while (refCount.getLockTaken()) {
                refCount.waitOnId();
            }
            refCount.takeLock();
        }
        finally {
            this.locksMapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(int id) {
        this.locksMapLock.lock();
        try {
            RefCount refCount = this.locksMap.get(id);
            if (refCount == null) {
                refCount = new RefCount(this.locksMapLock);
                this.locksMap.put(id, refCount);
            }
            if (refCount.getCount() != 0) {
                boolean bl = false;
                return bl;
            }
            refCount.incrementRefCount();
            refCount.takeLock();
            boolean bl = true;
            return bl;
        }
        finally {
            this.locksMapLock.unlock();
        }
    }

    public void unlock(int id) {
        this.locksMapLock.lock();
        try {
            RefCount refCount = this.locksMap.get(id);
            refCount.decrementRefCount();
            refCount.releaseLock();
            if (refCount.getCount() != 0) {
                refCount.nodifyForId();
            } else {
                this.locksMap.remove(id);
            }
        }
        finally {
            this.locksMapLock.unlock();
        }
    }

    private class RefCount {
        short bitField = 0;
        Condition cond;

        RefCount(Lock lock) {
            this.cond = lock.newCondition();
        }

        void incrementRefCount() {
            if ((this.bitField & 0x3FFF) == 16383) {
                throw new IllegalStateException("HashMapLocks: count exceeds the max allowed limit");
            }
            this.bitField = (short)(this.bitField + 1);
        }

        void decrementRefCount() {
            if ((this.bitField & 0x3FFF) == 0) {
                throw new IllegalStateException("HashMapLocks: illegal value for the ref count");
            }
            this.bitField = (short)(this.bitField - 1);
        }

        short getCount() {
            return (short)(this.bitField & 0x3FFF);
        }

        void waitOnId() {
            this.cond.awaitUninterruptibly();
        }

        void nodifyForId() {
            this.cond.signal();
        }

        void takeLock() {
            this.bitField = (short)(this.bitField | 0x4000);
        }

        void releaseLock() {
            this.bitField = (short)(this.bitField & 0xBFFF);
        }

        boolean getLockTaken() {
            return (this.bitField & 0x4000) == 16384;
        }
    }
}

