/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security.verifier;

public class Output {
    private static final boolean useColor = System.console() != null && System.getenv().get("TERM") != null;
    static boolean verbose = false;
    static boolean summary = false;

    public static void printH1(String format, Object ... args) {
        Output.printfl("### %s", String.format(format, args));
    }

    public static void printH2(String format, Object ... args) {
        Output.printfl(" ** %s", String.format(format, args));
    }

    public static void info(String info, Object ... args) {
        Output.printfl("   [\u25a1] %s", String.format(info, args));
    }

    public static void verbose(String info, Object ... args) {
        if (verbose) {
            Output.printfl("   [\u25a1] %s", String.format(info, args));
        }
    }

    public static void testSucceeded(String msg) {
        if (verbose) {
            Output.printfl("   [\u25cf] %s", msg);
        }
    }

    public static void testFailed(String msg) {
        Output.printfl("   [\u25cf] %s", msg);
    }

    public static void testFailed(Object actual, String msg) {
        Output.printfl("   [\u25cf] %s? %s (found %s)", msg, Output.red("false"), String.valueOf(actual));
    }

    public static void error(Throwable e) {
        Throwable cause = e;
        do {
            Output.error(cause.getMessage(), new Object[0]);
        } while ((cause = cause.getCause()) != null);
    }

    public static void error(String info, Object ... args) {
        Output.printfl("%s %s", Output.red("Error:"), String.format(info, args));
    }

    public static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    public static void printfl(String format, Object ... args) {
        System.out.printf(format, args);
        System.out.println();
    }

    public static String color(boolean bool) {
        return bool ? Output.green(bool) : Output.red(bool);
    }

    public static String red(Object obj) {
        return useColor ? "\u001b[31m" + String.valueOf(obj) + "\u001b[0m" : String.valueOf(obj);
    }

    public static String green(Object obj) {
        return useColor ? "\u001b[32m" + String.valueOf(obj) + "\u001b[0m" : String.valueOf(obj);
    }

    public static String yellow(Object obj) {
        return useColor ? "\u001b[33m" + String.valueOf(obj) + "\u001b[0m" : String.valueOf(obj);
    }
}

