/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security.verifier;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import com.mapr.web.security.verifier.Output;
import com.mapr.web.security.verifier.SecureFileVerifier;
import com.mapr.web.security.verifier.SecurityVerifierMain;
import com.mapr.web.security.verifier.Tests;

public class SslConfigVerifier {
    private final SecureFileVerifier secureFileVerifier;

    public SslConfigVerifier(SecurityVerifierMain tool) {
        this.secureFileVerifier = tool.getSecureFileVerifier();
    }

    public void verify(SslConfig.SslConfigScope sslConfigScope) {
        Tests.newTest("Verifying SslConfig with '%s'", Output.yellow((Object)sslConfigScope));
        boolean isServer = sslConfigScope == SslConfig.SslConfigScope.SCOPE_ALL;
        SslConfig sslConfig = WebSecurityConfig.CONFIG.getSslConfig(sslConfigScope);
        if (isServer) {
            Output.info("Server Keystore file type is '%s'", new Object[]{sslConfig.getServerKeystoreFileType()});
            this.secureFileVerifier.verify(sslConfig.getServerKeystoreLocation(), "r--------");
        } else {
            Output.info("Client Keystore file type is '%s'", new Object[]{sslConfig.getClientKeystoreFileType()});
            this.secureFileVerifier.verify(sslConfig.getClientTruststoreLocation(), "r--r--r--");
        }
        this.verifyPasswords(sslConfig, isServer);
    }

    private void verifyPasswords(SslConfig sslConfig, boolean isSecure) {
        char[] serverKeyPassword = sslConfig.getServerKeyPassword();
        Tests.assertAndPrint(serverKeyPassword != null == isSecure, "Server Key Password is%s null", isSecure ? " not" : "");
        char[] serverKeystorePassword = sslConfig.getServerKeystorePassword();
        Tests.assertAndPrint(serverKeystorePassword != null == isSecure, "Server Keystore Password is%s null", isSecure ? " not" : "");
        char[] serverTruststorePassword = sslConfig.getServerTruststorePassword();
        Tests.assertAndPrint(serverTruststorePassword != null == isSecure, "Server Truststore Password is%s null", isSecure ? " not" : "");
        char[] clientTruststorePassword = sslConfig.getClientTruststorePassword();
        Tests.assertAndPrint(clientTruststorePassword != null, "Client Truststore Password is not null", new Object[0]);
    }
}

