/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolStringList;
import com.mapr.baseutils.iamserverutils.IamServerRpcCommonUtils;
import com.mapr.baseutils.utils.TTLCache;
import com.mapr.fs.proto.IAMServerProto;
import com.mapr.fs.proto.PolicyServerProto;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamRolesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IamRolesHelper.class);
    private String strClusterName = null;
    private static final int TTL_CACHE_TIMEOUT = 3600;
    private static TTLCache<String, Integer> mapRoleNameToRoleId = null;
    private static TTLCache<Integer, String> mapRoleIdToRoleName = null;

    public IamRolesHelper(String strClusterName) {
        this.strClusterName = strClusterName;
        mapRoleNameToRoleId = new TTLCache(3600L);
        mapRoleIdToRoleName = new TTLCache(3600L);
    }

    public void addRole(int roleId, String roleName) {
        mapRoleIdToRoleName.put(roleId, roleName);
        mapRoleNameToRoleId.put(roleName, roleId);
    }

    public void removeRole(int roleId, String roleName) {
        mapRoleIdToRoleName.remove(roleId);
        mapRoleNameToRoleId.remove(roleName);
    }

    public HashSet<String> getRolenames(HashSet<Integer> roleIds) throws Exception {
        HashSet<String> roleNames = new HashSet<String>();
        if (roleIds == null || roleIds.isEmpty()) {
            return roleNames;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int roleId : roleIds) {
            if (mapRoleIdToRoleName.get(roleId) != null) continue;
            ids.add(roleId);
        }
        try {
            IAMServerProto.GetRoleNameFromRoleIdRequest request;
            if (!ids.isEmpty()) {
                request = IAMServerProto.GetRoleNameFromRoleIdRequest.newBuilder().addAllRoleId(ids).build();
                byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.GetRoleNameProc.getNumber(), (MessageLite)request);
                IAMServerProto.GetRoleNameFromRoleIdResponse response = IAMServerProto.GetRoleNameFromRoleIdResponse.parseFrom((byte[])data);
                if (response.getStatus() == 0 && response.getRoleNameCount() == ids.size()) {
                    ProtocolStringList names = response.getRoleNameList();
                    for (int index = 0; index < response.getRoleNameCount(); ++index) {
                        this.addRole((Integer)ids.get(index), (String)names.get(index));
                    }
                } else {
                    LOG.error("getRoleNames failed for {} with err {}, msg {}", new Object[]{((Object)ids).toString(), response.getStatus(), response.getErrMsg()});
                    throw new Exception(response.getErrMsg());
                }
            }
            request = roleIds.iterator();
            while (request.hasNext()) {
                int roleId = (Integer)request.next();
                String roleName = mapRoleIdToRoleName.get(roleId);
                if (roleName == null || roleName.isEmpty()) continue;
                roleNames.add(roleName);
            }
            return roleNames;
        }
        catch (Exception exp) {
            LOG.error("getRoleNames failed for {} with exception {}", (Object)((Object)ids).toString(), (Object)exp.getMessage());
            throw new Exception(exp.getMessage());
        }
    }

    public HashSet<Integer> getRoleIds(HashSet<String> roleNames) throws Exception {
        HashSet<Integer> roleIds = new HashSet<Integer>();
        if (roleNames == null || roleNames.isEmpty()) {
            return roleIds;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String roleName : roleNames) {
            if (mapRoleNameToRoleId.get(roleName) != null) continue;
            names.add(roleName);
        }
        try {
            if (!names.isEmpty()) {
                IAMServerProto.GetRoleIdFromRoleNameRequest request = IAMServerProto.GetRoleIdFromRoleNameRequest.newBuilder().addAllRoleName(names).build();
                byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.GetRoleNameProc.getNumber(), (MessageLite)request);
                IAMServerProto.GetRoleIdFromRoleNameResponse response = IAMServerProto.GetRoleIdFromRoleNameResponse.parseFrom((byte[])data);
                if (response.getStatus() == 0 && response.getRoleIdCount() == names.size()) {
                    List ids = response.getRoleIdList();
                    for (int index = 0; index < response.getRoleIdCount(); ++index) {
                        this.addRole((Integer)ids.get(index), (String)names.get(index));
                    }
                } else {
                    LOG.error("getRoleIds failed for {} with err {}, msg {}", new Object[]{((Object)names).toString(), response.getStatus(), response.getErrMsg()});
                    throw new Exception(response.getErrMsg());
                }
            }
            for (String roleName : roleNames) {
                Integer roleId = mapRoleNameToRoleId.get(roleName);
                if (roleId == null) continue;
                roleIds.add(roleId);
            }
            return roleIds;
        }
        catch (Exception exp) {
            LOG.error("getRoleIds failed for {} with exception {}", (Object)((Object)names).toString(), (Object)exp.getMessage());
            throw new Exception(exp.getMessage());
        }
    }

    public String getRolename(int roleId) {
        String roleName = mapRoleIdToRoleName.get(roleId);
        if (roleName != null && !roleName.isEmpty()) {
            return roleName;
        }
        try {
            IAMServerProto.GetRoleNameFromRoleIdRequest request = IAMServerProto.GetRoleNameFromRoleIdRequest.newBuilder().addRoleId(roleId).build();
            byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.GetRoleNameProc.getNumber(), (MessageLite)request);
            IAMServerProto.GetRoleNameFromRoleIdResponse response = IAMServerProto.GetRoleNameFromRoleIdResponse.parseFrom((byte[])data);
            if (response.getStatus() == 0 && !response.getRoleNameList().isEmpty()) {
                roleName = (String)response.getRoleNameList().get(0);
                this.addRole(roleId, roleName);
                return roleName;
            }
            LOG.error("getRoleNameFromId failed for {} with err {}, msg {}", new Object[]{roleId, response.getStatus(), response.getErrMsg()});
            return null;
        }
        catch (Exception exp) {
            LOG.error("getRoleNameFromId failed for {} with exception {}", (Object)roleId, (Object)exp.getMessage());
            return null;
        }
    }

    public Integer getRoleId(String roleName) {
        Integer roleId = mapRoleNameToRoleId.get(roleName);
        if (roleId != null) {
            return roleId;
        }
        try {
            IAMServerProto.GetRoleIdFromRoleNameRequest request = IAMServerProto.GetRoleIdFromRoleNameRequest.newBuilder().addRoleName(roleName).build();
            byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.GetRoleIdProc.getNumber(), (MessageLite)request);
            IAMServerProto.GetRoleIdFromRoleNameResponse response = IAMServerProto.GetRoleIdFromRoleNameResponse.parseFrom((byte[])data);
            if (response.getStatus() == 0 && !response.getRoleIdList().isEmpty()) {
                roleId = (Integer)response.getRoleIdList().get(0);
                this.addRole(roleId, roleName);
                return roleId;
            }
            LOG.error("getRoleIdFromName failed for {} with err {}, msg {}", new Object[]{roleName, response.getStatus(), response.getErrMsg()});
            return null;
        }
        catch (Exception exp) {
            LOG.error("getRoleIdFromName failed for {} with exception {}", (Object)roleName, (Object)exp.getMessage());
            return null;
        }
    }

    public HashSet<PolicyServerProto.IdentityInfoMsg> getUserToRoles(PolicyServerProto.IdentityInfoMsg user) throws Exception {
        HashSet<PolicyServerProto.IdentityInfoMsg> roles = new HashSet<PolicyServerProto.IdentityInfoMsg>();
        try {
            HashSet<PolicyServerProto.IdentityInfoMsg> identities = new HashSet<PolicyServerProto.IdentityInfoMsg>();
            identities.add(user);
            IAMServerProto.IamRoleMappingsRequest request = IAMServerProto.IamRoleMappingsRequest.newBuilder().addAllIdentities(identities).build();
            byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.RoleMappingsProc.getNumber(), (MessageLite)request);
            if (data == null) {
                LOG.error("Couldn't connect to the IamServer. Check if IamServer is up and running.");
                throw new Exception("Couldn't connect to the IamServer. Check if IamServer is up and running.");
            }
            IAMServerProto.IamRoleMappingsResponse response = IAMServerProto.IamRoleMappingsResponse.parseFrom((byte[])data);
            if (response.getStatus() != 0) {
                LOG.error("getUserToRoles failed for {} with err {}, msg {}", new Object[]{user, response.getStatus(), response.getErrMsg()});
                throw new Exception(response.getErrMsg());
            }
            List mappings = response.getMappingsList();
            roles.addAll(((IAMServerProto.IdentityToRoles)mappings.get(0)).getRolesList());
            return roles;
        }
        catch (Exception exp) {
            LOG.error("getUserToRoles failed for {} with exception {}", (Object)user, (Object)exp.getMessage());
            throw new Exception(exp.getMessage());
        }
    }

    public HashSet<PolicyServerProto.IdentityInfoMsg> getGroupToRoles(PolicyServerProto.IdentityInfoMsg group) throws Exception {
        HashSet<PolicyServerProto.IdentityInfoMsg> roles = new HashSet<PolicyServerProto.IdentityInfoMsg>();
        try {
            HashSet<PolicyServerProto.IdentityInfoMsg> identities = new HashSet<PolicyServerProto.IdentityInfoMsg>();
            identities.add(group);
            IAMServerProto.IamRoleMappingsRequest request = IAMServerProto.IamRoleMappingsRequest.newBuilder().addAllIdentities(identities).build();
            byte[] data = this.sendRequestToIamServer(IAMServerProto.IAMRoleProc.RoleMappingsProc.getNumber(), (MessageLite)request);
            if (data == null) {
                LOG.error("Couldn't connect to the IamServer. Check if IamServer is up and running.");
                throw new Exception("Couldn't connect to the IamServer. Check if IamServer is up and running.");
            }
            IAMServerProto.IamRoleMappingsResponse response = IAMServerProto.IamRoleMappingsResponse.parseFrom((byte[])data);
            if (response.getStatus() != 0) {
                LOG.error("getGroupToRoles failed for {} with err {}, msg {}", new Object[]{group, response.getStatus(), response.getErrMsg()});
                throw new Exception(response.getErrMsg());
            }
            List mappings = response.getMappingsList();
            roles.addAll(((IAMServerProto.IdentityToRoles)mappings.get(0)).getRolesList());
            return roles;
        }
        catch (Exception exp) {
            LOG.error("getGroupToRoles failed for {} with exception {}", (Object)group, (Object)exp.getMessage());
            throw new Exception(exp.getMessage());
        }
    }

    public static final HashSet<PolicyServerProto.IdentityInfoMsg> getIdentities(HashSet<Integer> idList, PolicyServerProto.IdentityType idType) {
        HashSet<PolicyServerProto.IdentityInfoMsg> identities = new HashSet<PolicyServerProto.IdentityInfoMsg>();
        for (int idItem : idList) {
            PolicyServerProto.IdentityInfoMsg.Builder identityInfo = PolicyServerProto.IdentityInfoMsg.newBuilder();
            identityInfo.setType(idType);
            identityInfo.setId(idItem);
            identities.add(identityInfo.build());
        }
        return identities;
    }

    private byte[] sendRequestToIamServer(int procId, MessageLite request) throws Exception {
        Class<IAMServerProto.GetRoleNameFromRoleIdResponse> response = null;
        byte[] data = null;
        switch (procId) {
            case 8: {
                response = IAMServerProto.GetRoleNameFromRoleIdResponse.class;
                break;
            }
            case 7: {
                response = IAMServerProto.GetRoleIdFromRoleNameResponse.class;
                break;
            }
            case 10: {
                response = IAMServerProto.IamRoleMappingsResponse.class;
                break;
            }
            default: {
                LOG.error("Unsupported proc {}", (Object)procId);
                return data;
            }
        }
        try {
            data = this.strClusterName == null || this.strClusterName.isEmpty() ? IamServerRpcCommonUtils.getInstance().sendRequestToIamServer(procId, request, response) : IamServerRpcCommonUtils.getInstance().sendRequestToIamServer(this.strClusterName, procId, request, response);
        }
        catch (Exception exp) {
            LOG.error("sendRequestToIamServer failed with exception {}", (Object)exp.getMessage());
            throw new Exception(exp);
        }
        return data;
    }
}

