/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.zookeeper.ZKClosedException;
import com.mapr.baseutils.zookeeper.ZKUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.security.JNISecurity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class KSStateManager {
    public static final Log LOG = LogFactory.getLog(KSStateManager.class);
    private ZooKeeper zk;
    private List<ACL> CLDB_ZK_ACLS = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private List<ACL> CREATOR_ALL_ACL_PLUS = new ArrayList<ACL>();
    public static final String ZK_KS_ROOT_PATH = "/ks_state";
    public static final String SERVICES_PATH = "/services";
    public static final String ZK_KS_SERVICE_PATH = "/ks_state/services";
    public static final String ZK_KS_STATE_PATH = "/ks_state/state";
    public static final String ZK_PATH_SEPERATOR = "/";

    public KSStateManager(ZooKeeper zk) {
        this.zk = zk;
        if (JNISecurity.IsSecurityEnabled(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) {
            this.CREATOR_ALL_ACL_PLUS.add(new ACL(30, ZooDefs.Ids.AUTH_IDS));
            this.CREATOR_ALL_ACL_PLUS.add(new ACL(1, new Id("sasl", "anyone")));
            this.CLDB_ZK_ACLS = this.CREATOR_ALL_ACL_PLUS;
        }
    }

    public CLDBProto.KSStateResponse getKSState() {
        byte[] data = null;
        CLDBProto.KSStateResponse.Builder resp = CLDBProto.KSStateResponse.newBuilder();
        try {
            if (this.zk.exists(ZK_KS_STATE_PATH, null) != null) {
                data = this.zk.getData(ZK_KS_STATE_PATH, null, null);
                CLDBProto.KSStateInfo info = CLDBProto.KSStateInfo.parseFrom((byte[])data);
                LOG.debug((Object)("KS: data in zk is :- " + info.toString()));
                return resp.setStatus(0).setStateInfo(info).build();
            }
        }
        catch (Exception e) {
            String msg = "getKSState failed to read value on znode /ks_state/state failed with exception " + e;
            LOG.error((Object)msg);
            return resp.setStatus(5).setErrMsg(msg).build();
        }
        String msg = "KSStateManager: getKSState znode /ks_state/state doesn't exists.";
        LOG.info((Object)msg);
        return resp.setStatus(2).setErrMsg(msg).build();
    }

    public int setDefaultKsState() {
        try {
            if (this.zk.exists(ZK_KS_STATE_PATH, null) == null) {
                LOG.info((Object)"KS: creating default kill switch state path");
                LOG.info((Object)"ZooKeeperClient creating the root ks state node: /ks_state");
                this.zk.create(ZK_KS_ROOT_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                LOG.info((Object)"ZooKeeperClient creating the node /ks_state/state");
                this.zk.create(ZK_KS_STATE_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                CLDBProto.KSStateInfo.Builder ksInfo = CLDBProto.KSStateInfo.newBuilder();
                ksInfo.setEnabled(false);
                ksInfo.setDisableInProgress(false);
                ksInfo.setEnableInProgress(false);
                ksInfo.setActivationKey("");
                ksInfo.setUsageFile("");
                ksInfo.clearSsoParams();
                ksInfo.setClusterId("");
                this.zk.setData(ZK_KS_STATE_PATH, ksInfo.build().toByteArray(), -1);
                LOG.info((Object)"KS: created default kill switch state");
            } else {
                LOG.info((Object)"KS: default state present, not creating");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"KS: Unable to determine/set default killswitch state");
            return 5;
        }
        return 0;
    }

    public CLDBProto.KSStateResponse setKSState(CLDBProto.KSStateInfo info) {
        byte[] data = null;
        CLDBProto.KSStateResponse.Builder resp = CLDBProto.KSStateResponse.newBuilder();
        try {
            if (this.zk.exists(ZK_KS_STATE_PATH, null) != null) {
                data = this.zk.getData(ZK_KS_STATE_PATH, null, null);
                if (data != null && data.length > 0) {
                    try {
                        CLDBProto.KSStateInfo rData = CLDBProto.KSStateInfo.parseFrom((byte[])data);
                        info = rData.toBuilder().mergeFrom(info).build();
                        LOG.info((Object)("KSS: Setting the kill switch state :- " + info.toString()));
                    }
                    catch (InvalidProtocolBufferException e) {
                        LOG.info((Object)"setKSState: existing data invalid, writing the new data");
                        LOG.error((Object)"KSStateManager InvalidProtocolBufferException while reading data from znode /ks_state/state");
                    }
                }
            } else {
                LOG.info((Object)"ZooKeeperClient creating the root ks state node: /ks_state");
                this.zk.create(ZK_KS_ROOT_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                LOG.info((Object)"ZooKeeperClient creating the node /ks_state/state");
                this.zk.create(ZK_KS_STATE_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
            }
            data = info.toByteArray();
            this.zk.setData(ZK_KS_STATE_PATH, data, -1);
        }
        catch (KeeperException.NoAuthException e) {
            String msg = "Access Denied: Only users with the 'mapr' role are authorized to execute this command. Please log in with a 'mapr' user account to proceed";
            LOG.error((Object)(msg + e));
            return resp.setStatus(13).setErrMsg(msg).build();
        }
        catch (Exception e) {
            String msg = "setKSState failed to update value on znode /ks_state/state failed with exception: " + e;
            LOG.error((Object)msg);
            return resp.setStatus(5).setErrMsg(msg).build();
        }
        return resp.setStatus(0).build();
    }

    public void resetKSState() {
        LOG.info((Object)"KSStateManager: resetting the ks state.");
        try {
            if (this.zk.exists(ZK_KS_ROOT_PATH, null) == null) {
                String msg = "KSStateManager: resetKSState znode /ks_state doesn't exists.";
                LOG.info((Object)msg);
                return;
            }
            this.deleteNodeRecursively(ZK_KS_ROOT_PATH);
        }
        catch (Exception e) {
            LOG.error((Object)("KSStateManager : facing issues in resetting the KS State. " + e));
        }
    }

    private void deleteNodeRecursively(String path) throws Exception {
        List<String> children = ZKUtils.getZkNodeChildren(this.zk, path, null, 3);
        for (String child : children) {
            this.deleteNodeRecursively(path + ZK_PATH_SEPERATOR + child);
        }
        LOG.info((Object)("KSStateManager: deleting the znode " + path));
        this.zk.delete(path, -1);
    }

    public void restartService(String service) {
        LOG.info((Object)("KSStateManager: restarting " + service));
        List<String> nodes = this.getServiceToNodeMapping(service);
        this.serviceManagementHelper(service, nodes, "restart");
    }

    public void noteService(String service) {
        LOG.info((Object)("KSStateManager: noting down nodes for svc: " + service));
        List<String> nodes = this.getServiceToNodeMapping(service);
        this.hostBackUp(service, nodes);
    }

    public void stopService(String service) {
        this.stopService(service, null);
    }

    public void stopService(String service, String masterAtLast) {
        LOG.info((Object)("KSStateManager: stopping " + service));
        List<String> nodes = this.getServiceToNodeMapping(service);
        this.hostBackUp(service, nodes);
        this.serviceManagementHelper(service, nodes, "stop", masterAtLast);
    }

    public void startService(String service) {
        LOG.info((Object)("KSStateManager: starting " + service));
        String backupServicesPath = ZK_KS_SERVICE_PATH;
        List<String> nodes = this.getServiceToNodeMapping(service, backupServicesPath);
        this.serviceManagementHelper(service, nodes, "start");
    }

    private int createNode(String path) {
        return this.createNode(path, new byte[0]);
    }

    private int createNode(String path, byte[] data) {
        int error = 0;
        try {
            this.zk.create(path, data, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (InterruptedException | KeeperException e) {
            LOG.error((Object)("KSStateManager: Unable to create node in zookeeper for: " + path));
            error = 14;
        }
        return error;
    }

    private void serviceManagementHelper(String service, List<String> nodes, String action) {
        this.serviceManagementHelper(service, nodes, action, null);
    }

    private void serviceManagementHelper(String service, List<String> nodes, String action, String masterAtLast) {
        if (nodes == null) {
            LOG.info((Object)(service + " is not running on any nodes."));
            return;
        }
        if (masterAtLast != null) {
            if (nodes.remove(masterAtLast)) {
                if (!nodes.add(masterAtLast)) {
                    LOG.error((Object)("KSStateManager: unable to add node to end of the list, node: " + masterAtLast));
                } else {
                    LOG.info((Object)("KSStateManager: moved node to last of the list, node: " + masterAtLast));
                }
            } else {
                LOG.error((Object)("KSStateManager: did not find the given master in the list of nodes, master: " + masterAtLast));
                for (String node : nodes) {
                    LOG.error((Object)("KSStateManager: nodes in list: " + node));
                }
                LOG.error((Object)("KSStateManager: not honoring service request, service: " + service + ", action: " + action));
                return;
            }
        }
        for (String node : nodes) {
            this.createNode("/nodes");
            this.createNode("/nodes/" + node);
            this.createNode("/nodes/" + node + SERVICES_PATH);
            this.createNode("/nodes/" + node + "/services/" + service);
            try {
                byte[] data = String.valueOf(System.currentTimeMillis()).getBytes();
                String createdNode = this.zk.create("/nodes/" + node + "/services/" + service + ZK_PATH_SEPERATOR + action + "_", data, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT_SEQUENTIAL);
                LOG.info((Object)("Created znode: " + createdNode + " to " + action + " service " + service));
            }
            catch (InterruptedException | KeeperException e) {
                LOG.error((Object)("KSStateManager: Facing issues in restarting " + service + (Exception)e));
            }
        }
    }

    private List<String> getServiceToNodeMapping(String service) {
        return this.getServiceToNodeMapping(service, SERVICES_PATH);
    }

    private List<String> getServiceToNodeMapping(String service, String basePath) {
        List<String> nodes = null;
        try {
            nodes = ZKUtils.getZkNodeChildren(this.zk, basePath + ZK_PATH_SEPERATOR + service, null, 3);
            LOG.info((Object)("KSStateManager: " + service + " service is running on these nodes :- " + nodes));
            nodes.remove("master");
        }
        catch (InterruptedException | KeeperException e) {
            LOG.error((Object)("KSStateManager: Can not get children of " + basePath + ZK_PATH_SEPERATOR + service + (Exception)e));
        }
        catch (ZKClosedException e) {
            LOG.error((Object)"KSStateManager: Facing issues in connectiong to zookeeper", (Throwable)e);
        }
        return nodes;
    }

    private void hostBackUp(String service, List<String> nodes) {
        try {
            if (this.zk.exists(ZK_KS_ROOT_PATH, null) == null) {
                LOG.info((Object)"KSStateManager: creating the node /ks_state");
                this.zk.create(ZK_KS_ROOT_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                LOG.info((Object)"KSStateManager: creating the node /ks_state/services");
                this.zk.create(ZK_KS_SERVICE_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                LOG.info((Object)("KSStateManager: creating the node /ks_state/services" + service));
                this.zk.create("/ks_state/services/" + service, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
            } else if (this.zk.exists(ZK_KS_SERVICE_PATH, null) == null) {
                LOG.info((Object)"KSStateManager: creating the node /ks_state/services");
                this.zk.create(ZK_KS_SERVICE_PATH, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                LOG.info((Object)("KSStateManager: creating the node /ks_state/services/" + service));
                this.zk.create("/ks_state/services/" + service, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
            } else if (this.zk.exists("/ks_state/services/" + service, null) == null) {
                LOG.info((Object)("KSStateManager: creating the node /ks_state/services/" + service));
                this.zk.create("/ks_state/services/" + service, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
            }
            for (String node : nodes) {
                String service_Host_Path = "/ks_state/services/" + service + ZK_PATH_SEPERATOR + node;
                try {
                    LOG.info((Object)("KSStateManager: creating the node " + service_Host_Path));
                    this.zk.create(service_Host_Path, null, this.CLDB_ZK_ACLS, CreateMode.PERSISTENT);
                }
                catch (Exception e) {
                    LOG.error((Object)("KSStateManager: failed to back up node " + node));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("KSStateManager: failed to create/check znode " + e));
        }
    }
}

