/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.fsrpcutils;

import com.mapr.baseutils.fsrpcutils.Utils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CidInfo {
    int cid;
    int nextReplicaServer;
    CidInfoState state;
    CLDBProto.ContainerInfo cInfo;
    ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public String toString() {
        Object s = "cid " + this.cid;
        s = ((String)s).concat(" state " + this.state);
        if (this.cInfo == null) {
            return s;
        }
        s = ((String)s).concat(" master server :");
        if (this.cInfo.hasMServer()) {
            s = ((String)s).concat(Utils.PrintServerIpAddress(this.cInfo.getMServer()));
        }
        s = ((String)s).concat(" replica servers :");
        for (int i = 0; i < this.cInfo.getAServersCount(); ++i) {
            s = ((String)s).concat(Utils.PrintServerIpAddress(this.cInfo.getAServers(i)));
        }
        return s;
    }

    CidInfo(int cid) {
        this.cid = cid;
        this.state = CidInfoState.StateInvalid;
        this.nextReplicaServer = 0;
        this.cInfo = null;
    }

    boolean needUpdate(boolean updateMaster) {
        if (this.state != CidInfoState.StateValid) {
            return true;
        }
        if (updateMaster) {
            return !this.cInfo.hasMServer();
        }
        return this.cInfo.getAServersCount() <= this.nextReplicaServer;
    }

    void UpdateContainerInfo(CLDBProto.ContainerInfo cInfo) {
        this.cInfo = cInfo;
        this.state = CidInfoState.StateValid;
        this.nextReplicaServer = 0;
    }

    public Common.Server getMasterServer() {
        return this.cInfo.getMServer();
    }

    public Common.Server getNextReplicaServer() {
        return this.cInfo.getAServers(this.nextReplicaServer);
    }

    public void incNextReplicaServer() {
        ++this.nextReplicaServer;
    }

    public static enum CidInfoState {
        StateInvalid,
        StateValid,
        StateFilling;

    }
}

