/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.filemonitor;

import com.mapr.baseutils.filemonitor.FileSystemListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FileSystemListenerBase
implements FileSystemListener {
    private Map<String, FileTime> files = new HashMap<String, FileTime>();

    protected FileSystemListenerBase(List<File> files) {
        if (files != null) {
            for (File file : files) {
                this.addFile(file);
            }
        }
    }

    protected FileSystemListenerBase(File file) {
        if (file != null) {
            this.addFile(file);
        }
    }

    protected FileSystemListenerBase() {
    }

    @Override
    public void addFile(File file) {
        if (file != null) {
            String absName = file.getAbsolutePath();
            long lastModifiedTime = 0L;
            if (file.exists()) {
                lastModifiedTime = file.lastModified();
            }
            this.files.put(absName, new FileTime(file, lastModifiedTime));
        }
    }

    @Override
    public Map<String, FileTime> getFiles() {
        return this.files;
    }

    @Override
    public void removeFile(File file) {
        if (file != null) {
            String absName = file.getAbsolutePath();
            this.files.remove(absName);
        }
    }

    public static class FileTime {
        private final File file;
        private long lastUpdateTime;

        FileTime(File file, long lastUpdateTime) {
            this.file = file;
            this.lastUpdateTime = lastUpdateTime;
        }

        public File getFile() {
            return this.file;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

