/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDirectoryFindingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LogDirectoryFindingUtils.class);
    private static final String hadoopVersionFile = "/hadoop/hadoopversion";

    private static String getHadoopVersion(String maprHome) {
        String version = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(maprHome + hadoopVersionFile));
            version = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOG.error("Error while trying to get hadoop version", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error while trying to get hadoop version", (Throwable)e);
        }
        return version;
    }

    public static String getHadoopLogsDirectory(String maprHome) {
        File hadoopDir = new File(maprHome + "/hadoop");
        String currentVersion = LogDirectoryFindingUtils.getHadoopVersion(maprHome);
        final String currentHadoopDir = "hadoop-" + currentVersion;
        if (hadoopDir.isDirectory()) {
            File[] hadoopVersions;
            for (File hadoopVersion : hadoopVersions = hadoopDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().equals(currentHadoopDir);
                }
            })) {
                try {
                    return hadoopVersion.getCanonicalPath() + "/logs";
                }
                catch (IOException e) {
                    LOG.error("Error while tring to get path for hadoop logs dir", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getHbaseLogsDirectory(String maprHome) {
        File hadoopDir = new File(maprHome + "/hbase");
        if (hadoopDir.isDirectory()) {
            File[] hadoopVersions;
            for (File hadoopVersion : hadoopVersions = hadoopDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().startsWith("hbase");
                }
            })) {
                try {
                    return hadoopVersion.getCanonicalPath() + "/logs";
                }
                catch (IOException e) {
                    LOG.error("Error while tring to get path for hbase logs dir", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getSchemaRegistryLogsDirectory(String maprHome) {
        File srDir = new File(maprHome + "/schema-registry");
        if (srDir.isDirectory()) {
            File[] srVersions;
            for (File srVersion : srVersions = srDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().startsWith("schema-registry");
                }
            })) {
                try {
                    return srVersion.getCanonicalPath() + "/logs";
                }
                catch (IOException e) {
                    LOG.error("Errori:: while tring to get path for schema-registry logs dir" + e);
                }
            }
        }
        return null;
    }
}

