/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.sso;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Installation;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.sso.JwtValidator;
import com.mapr.baseutils.sso.providers.keycloak.KeyCloakJwtValidator;
import com.mapr.baseutils.sso.providers.okta.OktaJwtValidator;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoManager {
    private static SsoManager s_instance;
    private String clientID = "";
    private String clientSecret = "";
    private String issuer = "";
    private String ssoProvider = "";
    private long lastModifiedSSOTime = 0L;
    private long lastRpcTime = 0L;
    private final int newRpcTime = 5000;
    private static Logger LOG;

    Security.CredentialsMsg buildCredentials() {
        try {
            UnixUserGroupHelper userInfo = new UnixUserGroupHelper();
            String clusterOwnerName = userInfo.getLoggedinUsername();
            int uid = userInfo.getUserId(clusterOwnerName);
            int[] gids = userInfo.getGroups(clusterOwnerName);
            if (gids == null || gids.length == 0) {
                gids = new int[]{uid};
            }
            Security.CredentialsMsg.Builder credsBuilder = Security.CredentialsMsg.newBuilder().setUserName(clusterOwnerName).setUid(uid);
            int[] nArray = gids;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long gid = nArray[i];
                credsBuilder.addGids((int)gid);
            }
            return credsBuilder.build();
        }
        catch (Exception e) {
            LOG.error("Error setting cluster credentials: " + e.toString() + " " + e.getMessage());
            throw e;
        }
    }

    public void readSsoParams() {
        if (!this.issuer.isEmpty() && this.lastRpcTime + 5000L > System.currentTimeMillis()) {
            return;
        }
        this.lastRpcTime = System.currentTimeMillis();
        CLDBProto.SsoGetConfigRequest.Builder req = CLDBProto.SsoGetConfigRequest.newBuilder();
        req.setCreds(this.buildCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SsoGetConfigProc.getNumber(), (MessageLite)req.build(), CLDBProto.SsoGetConfigResponse.class);
        }
        catch (Exception e) {
            LOG.error("readSsoParams: Error getting cluster credentials from cldb");
            return;
        }
        if (data != null) {
            CLDBProto.SsoGetConfigResponse resp = null;
            CLDBProto.SsoConfigParams ssoConfParams = null;
            try {
                resp = CLDBProto.SsoGetConfigResponse.parseFrom((byte[])data);
                ssoConfParams = resp.getSsoParams();
            }
            catch (InvalidProtocolBufferException e) {
                return;
            }
            if (ssoConfParams == null || !ssoConfParams.hasIssuer()) {
                return;
            }
            this.clientID = ssoConfParams.hasClientId() ? ssoConfParams.getClientId() : "";
            this.clientSecret = ssoConfParams.hasClientSecret() ? ssoConfParams.getClientSecret() : "";
            this.issuer = ssoConfParams.hasIssuer() ? ssoConfParams.getIssuer() : "";
            this.ssoProvider = ssoConfParams.hasType() ? ssoConfParams.getType() : "";
        }
    }

    public int updateSsoConfFiles(String iss, String type, String clientId, String clientSecret) {
        String ssoCreds;
        String ssoConf;
        Properties ssoConfProperties = new Properties();
        Properties ssoCredsProperties = new Properties();
        try {
            ssoConf = Installation.getMapRHome() + File.separator + "conf" + File.separator + "sso.conf";
            ssoConfProperties.load(new FileInputStream(ssoConf));
            ssoCreds = Installation.getMapRHome() + File.separator + "conf" + File.separator + "sso.creds";
            ssoCredsProperties.load(new FileInputStream(ssoCreds));
        }
        catch (Exception e) {
            LOG.error("Exception Loading SSO Conf File: ", (Throwable)e);
            return 5;
        }
        try {
            File ssoCredsFile = new File(ssoCreds);
            File ssoConfFile = new File(ssoConf);
            FileOutputStream confOutStream = new FileOutputStream(ssoConfFile);
            FileOutputStream credsOutStream = new FileOutputStream(ssoCredsFile);
            boolean changed = false;
            if (type != null) {
                ssoConfProperties.setProperty("sso.provider", type);
            }
            if (iss != null) {
                ssoConfProperties.setProperty("sso.issuers.list", iss);
            }
            if (type != null || iss != null) {
                ssoConfProperties.store(confOutStream, null);
                changed = true;
            }
            if (clientId != null) {
                ssoCredsProperties.setProperty("sso.client.id", clientId);
            }
            if (clientSecret != null) {
                ssoCredsProperties.setProperty("sso.client.secret", clientSecret);
            }
            if (clientId != null || clientSecret != null) {
                ssoCredsProperties.store(credsOutStream, null);
                changed = true;
            }
            if (changed) {
                this.readSsoParams();
            }
            return 0;
        }
        catch (Exception e) {
            LOG.error("Exception creating SSO Conf File out stream: ", (Throwable)e);
            return 5;
        }
    }

    public static synchronized SsoManager getInstance() {
        if (s_instance == null) {
            s_instance = new SsoManager();
        }
        return s_instance;
    }

    public String getClientID() {
        this.readSsoParams();
        return this.clientID;
    }

    public String getClientSecret() {
        this.readSsoParams();
        return this.clientSecret;
    }

    public String getIssuer() {
        this.readSsoParams();
        return this.issuer;
    }

    public String getSsoProvider() {
        this.readSsoParams();
        return this.ssoProvider;
    }

    public JwtValidator getValidator() {
        JwtValidator validator;
        String issuers = this.getIssuer();
        String ssoType = this.getSsoProvider();
        if (ssoType.toLowerCase().equals("keycloak")) {
            validator = new KeyCloakJwtValidator(issuers);
        } else if (ssoType.toLowerCase().equals("okta")) {
            validator = new OktaJwtValidator(issuers);
        } else {
            String err = "SSO scheme of type " + ssoType + " is not suppoted";
            LOG.error(err);
            return null;
        }
        return validator;
    }

    static {
        LOG = LoggerFactory.getLogger(SsoManager.class);
    }
}

