/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLProbingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(URLProbingUtility.class);

    public static boolean isURLReachable(String testUrl) {
        try {
            HttpURLConnection connection;
            URL url = new URL(testUrl);
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                connection = (HttpURLConnection)url.openConnection();
            } else if ("https".equalsIgnoreCase(protocol)) {
                connection = (HttpsURLConnection)url.openConnection();
            } else {
                LOG.error("URL has to be either http or https. No other formats are supported");
                return false;
            }
            connection.setConnectTimeout(15000);
            HttpsURLConnection.setFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Map<String, List<String>> headers;
                if (responseCode >= 300 && responseCode < 400) {
                    String newUrl = connection.getHeaderField("Location");
                    if (newUrl != null) {
                        if (newUrl.equals(testUrl)) {
                            LOG.error("Redirection loop detected. URL redirects to itself.");
                            return false;
                        }
                        return true;
                    }
                } else if (responseCode > 400 && responseCode < 500 && (headers = connection.getHeaderFields()).containsKey("WWW-Authenticate")) {
                    LOG.warn(testUrl + " requires authentication");
                    return true;
                }
                LOG.error("URL: " + testUrl + " returns invalid code: " + responseCode);
                return false;
            }
        }
        catch (MalformedURLException e) {
            LOG.error("URL: " + testUrl + " is malformed", (Throwable)e);
            return false;
        }
        catch (IOException x) {
            LOG.error("URL: " + testUrl + " can not be reached", (Throwable)x);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        System.out.println(URLProbingUtility.isURLReachable(args[0]));
    }
}

