/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprauth;

import com.mapr.fs.proto.Security;
import com.mapr.security.ClusterServerTicketGeneration;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.SecurityHelper;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AbstractMaprAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprAuthenticationHandler
extends AbstractMaprAuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(MaprAuthenticationHandler.class);

    public void init(Properties config) throws ServletException {
        try {
            ClusterServerTicketGeneration.getInstance().generateTicketAndSetServerKey();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public AuthenticationToken maprAuthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String authorization = request.getHeader("Authorization");
        if (!authorization.startsWith("MAPR-Negotiate")) {
            return null;
        }
        authorization = authorization.substring("MAPR-Negotiate".length()).trim();
        try {
            byte[] base64decoded = Base64.decodeBase64((String)authorization);
            LOG.trace("MaprAuthentication is started");
            Security.AuthenticationReqFull req = Security.AuthenticationReqFull.parseFrom((byte[])base64decoded);
            if (req != null && req.getEncryptedTicket() != null) {
                byte[] encryptedTicket = req.getEncryptedTicket().toByteArray();
                MutableInt err = new MutableInt();
                Security.Ticket decryptedTicket = Security.DecryptTicket(encryptedTicket, err);
                if (err.GetValue() != 0 || decryptedTicket == null) {
                    if (SecurityHelper.checkCLDBAuthReqFull(req)) {
                        String decryptError = "Error while decrypting ticket and key or invalid ticket for cluster" + err.GetValue();
                        response.setHeader("WWW-MAPR-Err-Authenticate", decryptError);
                        response.setStatus(401);
                        return null;
                    }
                    byte[] resp = SecurityHelper.createAuthRespWrongTicket().toByteArray();
                    Base64 base64 = new Base64(0);
                    String authenticate = base64.encodeToString(resp);
                    response.setHeader("Authorization", "MAPR-Negotiate " + authenticate);
                    response.setHeader("WWW-Authenticate", "Wrong Ticket Recieved");
                    response.setStatus(401);
                    LOG.trace("MaprAuthentication is completed on server side with wrong cluster");
                    return null;
                }
                Security.CredentialsMsg userCreds = decryptedTicket.getUserCreds();
                Security.Key userKey = decryptedTicket.getUserKey();
                String userName = userCreds.getUserName();
                byte[] secretNumberBytes = req.getEncryptedRandomSecret().toByteArray();
                byte[] secretNumberBytesDecrypted = Security.Decrypt(userKey, secretNumberBytes, err);
                if (secretNumberBytesDecrypted.length != 8) {
                    String badSecretError = "Bad random secret";
                    LOG.error(badSecretError);
                    response.setHeader("WWW-MAPR-Err-Authenticate", badSecretError);
                    response.setStatus(401);
                    return null;
                }
                long returnLong = ((long)secretNumberBytesDecrypted[0] << 56) + ((long)(secretNumberBytesDecrypted[1] & 0xFF) << 48) + ((long)(secretNumberBytesDecrypted[2] & 0xFF) << 40) + ((long)(secretNumberBytesDecrypted[3] & 0xFF) << 32) + ((long)(secretNumberBytesDecrypted[4] & 0xFF) << 24) + (long)((secretNumberBytesDecrypted[5] & 0xFF) << 16) + (long)((secretNumberBytesDecrypted[6] & 0xFF) << 8) + (long)((secretNumberBytesDecrypted[7] & 0xFF) << 0);
                LOG.trace("Received secret number: " + returnLong);
                Security.AuthenticationResp.Builder authResp = Security.AuthenticationResp.newBuilder();
                authResp.setChallengeResponse(++returnLong);
                authResp.setStatus(0);
                byte[] resp = authResp.build().toByteArray();
                byte[] respEncrypted = Security.Encrypt(userKey, resp, err);
                Base64 base64 = new Base64(0);
                String authenticate = base64.encodeToString(respEncrypted);
                response.setHeader("Authorization", "MAPR-Negotiate " + authenticate);
                LOG.trace("MaprAuthentication is completed on server side");
                return new AuthenticationToken(userName, userName, this.getType());
            }
            String clientRequestError = "Malformed client request";
            LOG.error(clientRequestError);
            response.setHeader("WWW-MAPR-Err-Authenticate", clientRequestError);
            response.setStatus(401);
            return null;
        }
        catch (Throwable t) {
            String serverKeyError = "Bad server key";
            LOG.error(serverKeyError, t);
            response.setHeader("WWW-MAPR-Err-Authenticate", serverKeyError);
            response.setStatus(401);
            return null;
        }
    }
}

