/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.sso.providers.okta;

import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.mapr.baseutils.sso.JwtValidator;
import com.okta.jwt.AccessTokenVerifier;
import com.okta.jwt.JwtVerifiers;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaJwtValidator
implements JwtValidator {
    private static HashSet<String> allowedIsses = new HashSet();
    private static Logger LOG = LoggerFactory.getLogger(OktaJwtValidator.class);

    public OktaJwtValidator() {
    }

    public OktaJwtValidator(String issuers) {
        this.setIssuers(issuers);
    }

    public String getTokenUrl(DecodedJWT token) {
        return token.getIssuer() + "/v1/token";
    }

    @Override
    public void setIssuers(String issuers) {
        allowedIsses.clear();
        String[] issuersList = issuers.split(",");
        for (int i = 0; i < issuersList.length; ++i) {
            LOG.debug("Got issuer: " + issuersList[i]);
            allowedIsses.add(issuersList[i]);
        }
    }

    @Override
    public String getCertificateUrl(DecodedJWT token) {
        return token.getIssuer() + "/v1/keys";
    }

    @Override
    public String getIntrospectionURL(DecodedJWT token) {
        return token.getIssuer() + "/v1/introspect";
    }

    @Override
    public RSAPublicKey loadPublicKey(DecodedJWT token) throws JwkException, MalformedURLException {
        String url = this.getCertificateUrl(token);
        UrlJwkProvider provider = new UrlJwkProvider(new URL(url));
        return (RSAPublicKey)provider.get(token.getKeyId()).getPublicKey();
    }

    @Override
    public DecodedJWT validate(String token) throws InvalidParameterException {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            if (!allowedIsses.contains(jwt.getIssuer())) {
                LOG.error("Unkown Issuer");
                throw new InvalidParameterException(String.format("Unknown Issuer %s", jwt.getIssuer()));
            }
            AccessTokenVerifier jwtVerifier = (AccessTokenVerifier)((AccessTokenVerifier.Builder)JwtVerifiers.accessTokenVerifierBuilder().setIssuer(jwt.getIssuer())).build();
            jwtVerifier.decode(token);
            return jwt;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            LOG.error("JWT validation failed: " + e.getMessage());
            throw new InvalidParameterException("JWT validation failed: " + e.getMessage());
        }
    }

    @Override
    public long expiresIn(String token) throws InvalidParameterException {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            Date expiresAt = jwt.getExpiresAt();
            Date currDate = new Date();
            long seconds = (expiresAt.getTime() - currDate.getTime()) / 1000L;
            return seconds;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new InvalidParameterException("JWT validation failed while getting expired time " + e.getMessage());
        }
    }

    @Override
    public String getUserName(String token) throws InvalidParameterException {
        return this.getClaim(token, "preferred_username");
    }

    @Override
    public String getClaim(String token, String key) throws InvalidParameterException {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            if (!allowedIsses.contains(jwt.getIssuer())) {
                throw new InvalidParameterException(String.format("Unknown Issuer %s", jwt.getIssuer()));
            }
            return jwt.getClaim(key).asString();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new InvalidParameterException("JWT validation failed while getting claim  " + key + e.getMessage());
        }
    }

    @Override
    public List<String> getClaimAsList(String token, String key) throws InvalidParameterException {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            if (!allowedIsses.contains(jwt.getIssuer())) {
                throw new InvalidParameterException(String.format("Unknown Issuer %s", jwt.getIssuer()));
            }
            return jwt.getClaim(key).asList(String.class);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new InvalidParameterException("JWT validation failed while getting claimList: " + e.getMessage());
        }
    }

    @Override
    public boolean introspect(String token, String clientId, String clientSecret) {
        block7: {
            try {
                String credential = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
                CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
                HttpPost request = new HttpPost(this.getIntrospectionURL(JWT.decode((String)token)));
                request.setHeader("Authorization", "Basic " + credential);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("token", token));
                params.add(new BasicNameValuePair("token_type_hint", "access_token"));
                try {
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    HttpResponse response = httpClient.execute((HttpUriRequest)request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 200) {
                        HttpEntity entity = response.getEntity();
                        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        JSONObject json = new JSONObject(responseString);
                        boolean isActive = json.getBoolean("active");
                        if (isActive) {
                            LOG.debug("Token is Active");
                            return true;
                        }
                        break block7;
                    }
                    LOG.error("response failed with error code in introspect token" + status);
                }
                catch (Exception e) {
                    LOG.error("Exception while executing http request in introspect token {}", (Object)e.getMessage());
                    if (LOG.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Exception while preparing http request in introspect token {}", (Object)e.getMessage());
                if (!LOG.isDebugEnabled()) break block7;
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String refreshToken(String token, String refreshToken, String clientId, String clientSecret) {
        block6: {
            try {
                String credential = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
                CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
                HttpPost request = new HttpPost(this.getTokenUrl(JWT.decode((String)token)));
                request.setHeader("Authorization", "Basic " + credential);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("grant_type", "refresh_token"));
                params.add(new BasicNameValuePair("refresh_token", refreshToken));
                try {
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    HttpResponse response = httpClient.execute((HttpUriRequest)request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 200) {
                        LOG.debug("refreshToken: Got Valid Response");
                        HttpEntity entity = response.getEntity();
                        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        JSONObject json = new JSONObject(responseString);
                        return json.getString("access_token");
                    }
                    LOG.error("response failed with error code in refresh token" + status);
                }
                catch (Exception e) {
                    LOG.error("Exception while executing http request in refresh token {}", (Object)e.getMessage());
                    if (LOG.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Exception while preparing http request in refresh token {}", (Object)e.getMessage());
                if (!LOG.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        return "";
    }
}

