/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.utils.ACL;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.util.List;

public class AclUtil {
    public static Security.AccessControlList.Builder mergeAcls(Security.AccessControlList oldAcl, Security.AccessControlList newAcl) {
        Security.AccessControlList.Builder oldAclBuilder = Security.AccessControlList.newBuilder((Security.AccessControlList)oldAcl);
        List currentAcls = oldAcl.getAclList();
        List newAcls = newAcl.getAclList();
        for (Security.AclEntry newaclentry : newAcls) {
            boolean foundMatch = false;
            int i = 0;
            for (Security.AclEntry aclentry : currentAcls) {
                if (newaclentry.hasPrincipal() && aclentry.hasPrincipal() && newaclentry.getPrincipal().getPrincId() == aclentry.getPrincipal().getPrincId()) {
                    foundMatch = true;
                    Security.AclEntry updatedEntry = Security.AclEntry.newBuilder((Security.AclEntry)((Security.AclEntry)currentAcls.get(i))).setAllow(newaclentry.getAllow()).build();
                    oldAclBuilder.setAcl(i, updatedEntry);
                    break;
                }
                ++i;
            }
            if (foundMatch) continue;
            oldAclBuilder.addAcl(newaclentry);
        }
        return oldAclBuilder;
    }

    public static String buildAclString(Security.AccessControlList aclList, UnixUserGroupHelper userInfo) {
        StringBuilder aclString = new StringBuilder();
        boolean firstUser = true;
        for (Security.AclEntry entry : aclList.getAclList()) {
            int princId = entry.getPrincipal().getPrincId();
            if (!firstUser) {
                aclString.append(",");
            }
            firstUser = false;
            if (ACL.isUid(princId)) {
                try {
                    aclString.append(userInfo.getUsername(princId) + ":");
                }
                catch (SecurityException se) {
                    aclString.append(princId + ":");
                }
            } else {
                try {
                    aclString.append(userInfo.getGroupname(ACL.getGid(princId)) + ":");
                }
                catch (SecurityException se) {
                    aclString.append(ACL.getGid(princId) + ":");
                }
            }
            int allowMask = entry.getAllow();
            List<String> actions = SecurityCommandHelper.formatActionMask(allowMask, CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER, true);
            boolean firstPerm = true;
            for (String action : actions) {
                if (!firstPerm) {
                    aclString.append(",");
                }
                firstPerm = false;
                aclString.append(action);
            }
        }
        return aclString.toString();
    }

    public static Security.AccessControlList.Builder purgeEmptyAclEntries(Security.AccessControlList.Builder inputBuilder) {
        Security.AccessControlList.Builder outputBuilder = Security.AccessControlList.newBuilder();
        for (Security.AclEntry entry : inputBuilder.getAclList()) {
            if (AclUtil.isAclEntryEmpty(entry)) continue;
            outputBuilder.addAcl(entry);
        }
        return outputBuilder;
    }

    public static boolean hasEmptyAcls(Security.AccessControlList acl) {
        if (acl != null) {
            for (Security.AclEntry entry : acl.getAclList()) {
                if (!AclUtil.isAclEntryEmpty(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAclEntryEmpty(Security.AclEntry entry) {
        return entry.getAllow() == 0 && entry.getDeny() == 0;
    }
}

