/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.baseutils.Installation;
import com.mapr.web.security.KeystoreFileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;

public class SecurityConf {
    private static final AtomicReference<Object> fipsEnabled = new AtomicReference();

    private SecurityConf() {
    }

    private static boolean checkFipsEnabled() {
        String maprConfDir = Installation.getMaprConfDir();
        File sslClientXml = new File(maprConfDir, "ssl-client.xml");
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)new FileInputStream(sslClientXml), false);
        String clientTruststoreType = conf.get("ssl.client.truststore.type");
        KeystoreFileType clientTruststoreFileType = KeystoreFileType.fromName(clientTruststoreType);
        return KeystoreFileType.BCFKS == clientTruststoreFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFipsEnabled() {
        Object value = fipsEnabled.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = fipsEnabled;
            synchronized (atomicReference) {
                value = fipsEnabled.get();
                if (value == null) {
                    boolean actualValue = SecurityConf.checkFipsEnabled();
                    value = actualValue;
                    fipsEnabled.set(value);
                }
            }
        }
        return (Boolean)value;
    }
}

