/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AceUtil {
    private static final Logger LOG = LogManager.getLogger(AceUtil.class);
    private static final int MOST_SIGNIFICANT_BIT = 31;

    private static boolean accessAllowed(Security.AclEntry aclEntry, int index) {
        if (!aclEntry.hasAllow()) {
            return false;
        }
        return (aclEntry.getAllow() & 1 << index) != 0;
    }

    public static Common.VolumeAces volumeAclToVolumeAces(Security.AccessControlList acl) throws IOException {
        HashMap<Common.VolumeActions, StringBuilder> allowList = new HashMap<Common.VolumeActions, StringBuilder>();
        for (Security.AclEntry aclEntry : acl.getAclList()) {
            Security.SecurityPrincipal principal = aclEntry.getPrincipal();
            if (!principal.hasPrincId()) continue;
            int principalId = principal.getPrincId();
            Object perm = principalId == -1 ? "p" : (principalId < 0 ? "g:" + Integer.toString(principalId & Integer.MAX_VALUE) : "u:" + Integer.toString(principalId));
            for (Common.VolumeActions volumeAction : Common.VolumeActions.values()) {
                if (!AceUtil.accessAllowed(aclEntry, volumeAction.getNumber())) continue;
                StringBuilder strBuilder = (StringBuilder)allowList.get(volumeAction);
                if (strBuilder == null) {
                    strBuilder = new StringBuilder((String)perm);
                    allowList.put(volumeAction, strBuilder);
                    continue;
                }
                strBuilder.append("|" + (String)perm);
            }
        }
        Common.VolumeAces.Builder volumeAcesBuilder = Common.VolumeAces.newBuilder();
        for (Common.VolumeActions volumeAction : allowList.keySet()) {
            String ace = AceHelper.toPostfix(((StringBuilder)allowList.get(volumeAction)).toString());
            volumeAcesBuilder.addAces(Common.VolumeAceEntry.newBuilder().setAccessType(volumeAction).setExpr(ByteString.copyFromUtf8((String)ace)));
        }
        return volumeAcesBuilder.build();
    }

    public static Common.VolumeAces mergeVolumeIamAces(Common.VolumeAces currentIamAces, Common.VolumeAces updateIamAces, boolean mergeAces) throws IOException {
        if (currentIamAces == null || !mergeAces) {
            return updateIamAces;
        }
        if (updateIamAces == null || !updateIamAces.getIamAces()) {
            return currentIamAces;
        }
        HashMap<Common.VolumeActions, Common.VolumeAceEntry> volumeIamAcesMap = new HashMap<Common.VolumeActions, Common.VolumeAceEntry>();
        Common.VolumeAces.Builder volumeIamAcesBuilder = Common.VolumeAces.newBuilder();
        for (Common.VolumeAceEntry volumeIamAceEntry : currentIamAces.getAcesList()) {
            volumeIamAcesMap.put(volumeIamAceEntry.getAccessType(), volumeIamAceEntry);
        }
        for (Common.VolumeAceEntry volumeIamAceEntry : updateIamAces.getAcesList()) {
            String strAceExpr;
            Common.VolumeAceEntry existingAceEntry = (Common.VolumeAceEntry)volumeIamAcesMap.get(volumeIamAceEntry.getAccessType());
            String updateExpr = volumeIamAceEntry.getExpr().toStringUtf8();
            if (existingAceEntry != null && !(strAceExpr = existingAceEntry.getExpr().toStringUtf8()).isEmpty() && !strAceExpr.equalsIgnoreCase("p")) {
                if (updateExpr.isEmpty() || updateExpr.equalsIgnoreCase("p")) continue;
                String infixAceExpr = AceHelper.toInfix(strAceExpr) + "|" + AceHelper.toInfix(volumeIamAceEntry.getExpr().toStringUtf8());
                LOG.debug("InfixAceExpr: " + infixAceExpr);
                String postfixAceExpr = AceHelper.toPostfix(infixAceExpr);
                volumeIamAceEntry = Common.VolumeAceEntry.newBuilder((Common.VolumeAceEntry)volumeIamAceEntry).setExpr(ByteString.copyFromUtf8((String)postfixAceExpr)).build();
            }
            volumeIamAcesMap.put(volumeIamAceEntry.getAccessType(), volumeIamAceEntry);
        }
        HashMap<Common.VolumeActions, Common.VolumeAceEntry> volumeIamDenyAcesMap = new HashMap<Common.VolumeActions, Common.VolumeAceEntry>();
        for (Common.VolumeAceEntry volumeIamAceDenyEntry : currentIamAces.getDenyAcesList()) {
            volumeIamDenyAcesMap.put(volumeIamAceDenyEntry.getAccessType(), volumeIamAceDenyEntry);
        }
        for (Common.VolumeAceEntry volumeIamAceDenyEntry : updateIamAces.getDenyAcesList()) {
            String strDenyAceExpr;
            LOG.debug("Inside Deny aces");
            Common.VolumeAceEntry existingDenyAceEntry = (Common.VolumeAceEntry)volumeIamDenyAcesMap.get(volumeIamAceDenyEntry.getAccessType());
            if (existingDenyAceEntry != null && (strDenyAceExpr = existingDenyAceEntry.getExpr().toStringUtf8()) != null && !strDenyAceExpr.isEmpty()) {
                String infixDenyAceExpr = AceHelper.toInfix(strDenyAceExpr) + "|" + AceHelper.toInfix(volumeIamAceDenyEntry.getExpr().toStringUtf8());
                LOG.debug("InfixDenyAceExpr: " + infixDenyAceExpr);
                String postfixAceDenyExpr = AceHelper.toPostfix(infixDenyAceExpr);
                volumeIamAceDenyEntry = Common.VolumeAceEntry.newBuilder((Common.VolumeAceEntry)volumeIamAceDenyEntry).setExpr(ByteString.copyFromUtf8((String)postfixAceDenyExpr)).build();
            }
            volumeIamDenyAcesMap.put(volumeIamAceDenyEntry.getAccessType(), volumeIamAceDenyEntry);
        }
        for (Common.VolumeActions volumeAction : volumeIamAcesMap.keySet()) {
            volumeIamAcesBuilder.addAces((Common.VolumeAceEntry)volumeIamAcesMap.get(volumeAction));
        }
        for (Common.VolumeActions volumeAction : volumeIamDenyAcesMap.keySet()) {
            volumeIamAcesBuilder.addDenyAces((Common.VolumeAceEntry)volumeIamDenyAcesMap.get(volumeAction));
        }
        volumeIamAcesBuilder.setIamAces(true);
        volumeIamAcesBuilder.setEnforcePolicies(false);
        volumeIamAcesBuilder.setEnforceIamAces(true);
        return volumeIamAcesBuilder.build();
    }

    public static Common.VolumeAces mergeVolumeAces(Common.VolumeAces currentAces, Common.VolumeAces newAces) {
        if (currentAces == null) {
            return newAces;
        }
        if (newAces == null) {
            return currentAces;
        }
        HashMap<Common.VolumeActions, Object> volumeAcesMap = new HashMap<Common.VolumeActions, Object>();
        for (Object volumeAceEntry : currentAces.getAcesList()) {
            volumeAcesMap.put(volumeAceEntry.getAccessType(), volumeAceEntry);
        }
        for (Object volumeAceEntry : newAces.getAcesList()) {
            volumeAcesMap.put(volumeAceEntry.getAccessType(), volumeAceEntry);
        }
        Common.VolumeAces.Builder volumeAcesBuilder = Common.VolumeAces.newBuilder();
        for (Common.VolumeActions volumeAction : volumeAcesMap.keySet()) {
            volumeAcesBuilder.addAces((Common.VolumeAceEntry)volumeAcesMap.get(volumeAction));
        }
        HashMap<Common.VolumeActions, Common.VolumeAceEntry> volumeDenyAcesMap = new HashMap<Common.VolumeActions, Common.VolumeAceEntry>();
        for (Common.VolumeAceEntry volumeAceDenyEntry : currentAces.getDenyAcesList()) {
            volumeDenyAcesMap.put(volumeAceDenyEntry.getAccessType(), volumeAceDenyEntry);
        }
        for (Common.VolumeAceEntry volumeAceDenyEntry : newAces.getDenyAcesList()) {
            volumeDenyAcesMap.put(volumeAceDenyEntry.getAccessType(), volumeAceDenyEntry);
        }
        for (Common.VolumeActions volumeAction : volumeDenyAcesMap.keySet()) {
            volumeAcesBuilder.addDenyAces((Common.VolumeAceEntry)volumeDenyAcesMap.get(volumeAction));
        }
        if (currentAces.getPolicyIdsCount() > 0) {
            volumeAcesBuilder.addAllPolicyIds((Iterable)currentAces.getPolicyIdsList());
        }
        if (currentAces.getPolicyNamesCount() > 0) {
            volumeAcesBuilder.addAllPolicyNames((Iterable)currentAces.getPolicyNamesList());
        }
        if (currentAces.hasEnforceAces()) {
            volumeAcesBuilder.setEnforceAces(currentAces.getEnforceAces());
        }
        if (currentAces.hasEnforcePolicies()) {
            volumeAcesBuilder.setEnforcePolicies(currentAces.getEnforcePolicies());
        }
        if (currentAces.hasCompositePolicyId()) {
            volumeAcesBuilder.setCompositePolicyId(currentAces.getCompositePolicyId());
        }
        if (currentAces.hasEnableAuditOnlyPolicyCheck()) {
            volumeAcesBuilder.setEnableAuditOnlyPolicyCheck(currentAces.getEnableAuditOnlyPolicyCheck());
        }
        if (newAces.getPolicyIdsCount() > 0) {
            volumeAcesBuilder.clearPolicyIds();
            volumeAcesBuilder.addAllPolicyIds((Iterable)newAces.getPolicyIdsList());
        }
        if (newAces.getPolicyNamesCount() > 0) {
            volumeAcesBuilder.clearPolicyNames();
            volumeAcesBuilder.addAllPolicyNames((Iterable)newAces.getPolicyNamesList());
        }
        if (newAces.hasEnforceAces()) {
            volumeAcesBuilder.setEnforceAces(newAces.getEnforceAces());
        }
        if (newAces.hasEnforcePolicies()) {
            volumeAcesBuilder.setEnforcePolicies(newAces.getEnforcePolicies());
        }
        if (newAces.hasCompositePolicyId()) {
            volumeAcesBuilder.setCompositePolicyId(newAces.getCompositePolicyId());
        }
        if (newAces.hasEnableAuditOnlyPolicyCheck()) {
            volumeAcesBuilder.setEnableAuditOnlyPolicyCheck(newAces.getEnableAuditOnlyPolicyCheck());
        }
        return volumeAcesBuilder.build();
    }

    public static Common.FileACEs mergeFileAces(Common.FileACEs currentAces, Common.FileACEs newAces) {
        if (currentAces == null || currentAces.getAcesCount() == 0) {
            return newAces;
        }
        if (newAces == null || newAces.getAcesCount() == 0) {
            return currentAces;
        }
        HashMap<Common.FSAccessType, Common.FileACE> fileAcesMap = new HashMap<Common.FSAccessType, Common.FileACE>();
        for (Common.FileACE fileAceEntry : currentAces.getAcesList()) {
            fileAcesMap.put(fileAceEntry.getAccessType(), fileAceEntry);
        }
        for (Common.FileACE fileAceEntry : newAces.getAcesList()) {
            fileAcesMap.put(fileAceEntry.getAccessType(), fileAceEntry);
        }
        Common.FileACEs.Builder fileAcesBuilder = Common.FileACEs.newBuilder();
        for (Common.FSAccessType fsAccessType : fileAcesMap.keySet()) {
            fileAcesBuilder.addAces((Common.FileACE)fileAcesMap.get(fsAccessType));
        }
        return fileAcesBuilder.build();
    }

    public static List<Common.DBStreamAceEntry> mergeDbStreamAces(List<Common.DBStreamAceEntry> currentAces, List<Common.DBStreamAceEntry> newAces) {
        if (currentAces.size() == 0) {
            return newAces;
        }
        if (newAces.size() == 0) {
            return currentAces;
        }
        HashMap<Common.DBStreamAccessType, Common.DBStreamAceEntry> dbAcesMap = new HashMap<Common.DBStreamAccessType, Common.DBStreamAceEntry>();
        for (Common.DBStreamAceEntry dbAceEntry : currentAces) {
            dbAcesMap.put(dbAceEntry.getAccessType(), dbAceEntry);
        }
        for (Common.DBStreamAceEntry dbAceEntry : newAces) {
            dbAcesMap.put(dbAceEntry.getAccessType(), dbAceEntry);
        }
        ArrayList<Common.DBStreamAceEntry> dbAcesBuilder = new ArrayList<Common.DBStreamAceEntry>();
        for (Common.DBStreamAccessType dbAccessType : dbAcesMap.keySet()) {
            dbAcesBuilder.add((Common.DBStreamAceEntry)dbAcesMap.get(dbAccessType));
        }
        return dbAcesBuilder;
    }

    public static Common.SecurityPolicyProperties expandSecurityPolicyAces(Common.SecurityPolicyProperties secPolProps) {
        if (!secPolProps.hasReadAces() && !secPolProps.hasWriteAces()) {
            return secPolProps;
        }
        Common.SecurityPolicyProperties.Builder spPropB = Common.SecurityPolicyProperties.newBuilder((Common.SecurityPolicyProperties)secPolProps).clearReadAces().clearWriteAces();
        Common.FileACEs.Builder fileAcesBuilder = Common.FileACEs.newBuilder();
        ArrayList<Common.DBStreamAceEntry> dbAcesBuilder = new ArrayList<Common.DBStreamAceEntry>();
        if (secPolProps.hasReadAces()) {
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceRead).setBoolExp(secPolProps.getReadAces()).build());
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceLookupDir).setBoolExp(secPolProps.getReadAces()).build());
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceReadDir).setBoolExp(secPolProps.getReadAces()).build());
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceExecute).setBoolExp(secPolProps.getReadAces()).build());
            dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceReadDB).setExpr(secPolProps.getReadAces()).build());
            dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceTraverse).setExpr(secPolProps.getReadAces()).build());
        }
        if (secPolProps.hasWriteAces()) {
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceWrite).setBoolExp(secPolProps.getWriteAces()).build());
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceAddChild).setBoolExp(secPolProps.getWriteAces()).build());
            fileAcesBuilder.addAces(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.AceDeleteChild).setBoolExp(secPolProps.getWriteAces()).build());
            dbAcesBuilder.add(Common.DBStreamAceEntry.newBuilder().setAccessType(Common.DBStreamAccessType.AceWriteDB).setExpr(secPolProps.getWriteAces()).build());
        }
        spPropB.clearFileAces();
        spPropB.clearDbStreamAces();
        fileAcesBuilder.addAllAces((Iterable)secPolProps.getFileAces().getAcesList());
        dbAcesBuilder.addAll(secPolProps.getDbStreamAcesList());
        spPropB.setFileAces(fileAcesBuilder);
        spPropB.addAllDbStreamAces(dbAcesBuilder);
        return spPropB.build();
    }

    public static Common.SecurityPolicyProperties compactSecurityPolicyAces(Common.SecurityPolicyProperties secPolProps) {
        boolean canCompactReadAces = true;
        boolean canCompactWriteAces = true;
        HashSet<String> readAceExpr_Set = new HashSet<String>();
        HashSet<String> writeAceExpr_Set = new HashSet<String>();
        Common.DBStreamAceEntry unmaskedReadAce = null;
        if (!secPolProps.hasFileAces() || secPolProps.getDbStreamAcesCount() == 0) {
            return secPolProps;
        }
        HashSet<CallSite> readAccessType = new HashSet<CallSite>();
        HashSet<CallSite> writeAccessType = new HashSet<CallSite>();
        readAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceRead)));
        readAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceLookupDir)));
        readAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceReadDir)));
        readAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceExecute)));
        readAccessType.add((CallSite)((Object)("db" + Common.DBStreamAccessType.AceReadDB)));
        readAccessType.add((CallSite)((Object)("db" + Common.DBStreamAccessType.AceTraverse)));
        writeAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceWrite)));
        writeAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceAddChild)));
        writeAccessType.add((CallSite)((Object)("fs" + Common.FSAccessType.AceDeleteChild)));
        writeAccessType.add((CallSite)((Object)("db" + Common.DBStreamAccessType.AceWriteDB)));
        ArrayList<Common.FileACE> fsCurrentReadAcesList = new ArrayList<Common.FileACE>();
        ArrayList<Common.FileACE> fsCurrentWriteAcesList = new ArrayList<Common.FileACE>();
        ArrayList<Common.DBStreamAceEntry> dbCurrentReadAcesList = new ArrayList<Common.DBStreamAceEntry>();
        ArrayList<Common.DBStreamAceEntry> dbCurrentWriteAcesList = new ArrayList<Common.DBStreamAceEntry>();
        for (Common.FileACE fileAceEntry : secPolProps.getFileAces().getAcesList()) {
            Common.FSAccessType fAccessType = fileAceEntry.getAccessType();
            readAccessType.remove("fs" + fAccessType);
            writeAccessType.remove("fs" + fAccessType);
            if (fAccessType == Common.FSAccessType.AceRead || fAccessType == Common.FSAccessType.AceLookupDir || fAccessType == Common.FSAccessType.AceReadDir || fAccessType == Common.FSAccessType.AceExecute) {
                readAceExpr_Set.add(fileAceEntry.getBoolExp().toStringUtf8());
                fsCurrentReadAcesList.add(fileAceEntry);
            }
            if (fAccessType != Common.FSAccessType.AceWrite && fAccessType != Common.FSAccessType.AceAddChild && fAccessType != Common.FSAccessType.AceDeleteChild) continue;
            writeAceExpr_Set.add(fileAceEntry.getBoolExp().toStringUtf8());
            fsCurrentWriteAcesList.add(fileAceEntry);
        }
        for (Common.DBStreamAceEntry dbAceEntry : secPolProps.getDbStreamAcesList()) {
            Common.DBStreamAccessType dbAccessType = dbAceEntry.getAccessType();
            if (dbAccessType == Common.DBStreamAccessType.AceUnmaskedReadDB) {
                unmaskedReadAce = dbAceEntry;
                continue;
            }
            readAccessType.remove("db" + dbAccessType);
            writeAccessType.remove("db" + dbAccessType);
            if (dbAccessType == Common.DBStreamAccessType.AceReadDB || dbAccessType == Common.DBStreamAccessType.AceTraverse) {
                readAceExpr_Set.add(dbAceEntry.getExpr().toStringUtf8());
                dbCurrentReadAcesList.add(dbAceEntry);
            }
            if (dbAccessType != Common.DBStreamAccessType.AceWriteDB) continue;
            writeAceExpr_Set.add(dbAceEntry.getExpr().toStringUtf8());
            dbCurrentWriteAcesList.add(dbAceEntry);
        }
        if (readAceExpr_Set.size() != 1 || !readAccessType.isEmpty()) {
            canCompactReadAces = false;
        }
        if (writeAceExpr_Set.size() != 1 || !writeAccessType.isEmpty()) {
            canCompactWriteAces = false;
        }
        if (!canCompactWriteAces && !canCompactReadAces) {
            return secPolProps;
        }
        Common.SecurityPolicyProperties.Builder spPropB = Common.SecurityPolicyProperties.newBuilder((Common.SecurityPolicyProperties)secPolProps).clearFileAces().clearDbStreamAces();
        if (unmaskedReadAce != null) {
            spPropB.addDbStreamAces(unmaskedReadAce);
        }
        if (canCompactReadAces) {
            spPropB.setReadAces(ByteString.copyFromUtf8((String)((String)readAceExpr_Set.iterator().next())));
            fsCurrentReadAcesList.clear();
            dbCurrentReadAcesList.clear();
        }
        if (canCompactWriteAces) {
            spPropB.setWriteAces(ByteString.copyFromUtf8((String)((String)writeAceExpr_Set.iterator().next())));
            fsCurrentWriteAcesList.clear();
            dbCurrentWriteAcesList.clear();
        }
        if (fsCurrentReadAcesList.size() > 0 || fsCurrentWriteAcesList.size() > 0) {
            Common.FileACEs.Builder fACEsB = Common.FileACEs.newBuilder();
            fACEsB.addAllAces(fsCurrentReadAcesList);
            fACEsB.addAllAces(fsCurrentWriteAcesList);
            spPropB.setFileAces(fACEsB.build());
        }
        if (dbCurrentReadAcesList.size() > 0) {
            spPropB.addAllDbStreamAces(dbCurrentReadAcesList);
        }
        if (dbCurrentWriteAcesList.size() > 0) {
            spPropB.addAllDbStreamAces(dbCurrentWriteAcesList);
        }
        return spPropB.build();
    }

    static void printVolumeIamAceInfo(Common.VolumeAces volumeIamAces, Log LOG) {
        if (volumeIamAces == null || !LOG.isDebugEnabled()) {
            return;
        }
        if (volumeIamAces.getIamAces()) {
            for (Common.VolumeAceEntry volumeIamAceEntry : volumeIamAces.getAcesList()) {
                LOG.debug((Object)("Volume Action: " + volumeIamAceEntry.getAccessType().name() + " IAM Ace: " + volumeIamAceEntry.getExpr().toStringUtf8()));
            }
        } else {
            LOG.error((Object)"Volume IAM ACEs not available");
        }
    }

    static void printVolumeAceInfo(Common.VolumeAces volumeAces, Log LOG) {
        if (volumeAces == null || !LOG.isDebugEnabled()) {
            return;
        }
        for (Common.VolumeAceEntry volumeAceEntry : volumeAces.getAcesList()) {
            LOG.debug((Object)("Volume Action: " + volumeAceEntry.getAccessType().name() + " Ace: " + volumeAceEntry.getExpr().toStringUtf8()));
        }
    }
}

