/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlReader {
    private Document doc;

    public XmlReader(String resourceName) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.init(resourceName);
    }

    public void init(String resourceName) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException("Missing resource " + resourceName);
        }
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = dBuilder.parse(new File(url.toURI()));
        this.doc.getDocumentElement().normalize();
    }

    public String getValue(String attribute, String parentTag, String attribTag, String valueTag) {
        NodeList nList = this.doc.getElementsByTagName(parentTag);
        for (int i = 0; i < nList.getLength(); ++i) {
            Element element;
            String _attribute;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || !attribute.equals(_attribute = (element = (Element)node).getElementsByTagName(attribTag).item(0).getTextContent())) continue;
            return element.getElementsByTagName(valueTag).item(0).getTextContent();
        }
        return null;
    }

    public String getValue(String attribute, String parentTag) {
        return this.getValue(attribute, parentTag, "name", "value");
    }

    public String getValue(String attribute) {
        return this.getValue(attribute, "property", "name", "value");
    }
}

