/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.metric;

import com.mapr.baseutils.metric.JobMetricRepo;
import com.mapr.baseutils.metric.MetricRepo;
import com.mapr.baseutils.metric.NodeMetricRepo;
import com.mapr.baseutils.metric.TaskAttemptMetricRepo;
import com.mapr.baseutils.metric.TaskMetricRepo;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import java.util.ArrayList;
import java.util.List;

public class MetricRepoFactory {
    private static MetricRepoFactory s_instance = new MetricRepoFactory();

    private MetricRepoFactory() {
    }

    public static MetricRepoFactory getInstance() {
        return s_instance;
    }

    public List<MetricRepo> getMetricRepo(ClusterMetricsProto.Metric metric) {
        ArrayList<MetricRepo> retValue = new ArrayList<MetricRepo>();
        if (metric.hasJobMetric()) {
            retValue.add(new JobMetricRepo(metric.getJobMetric()));
        }
        if (metric.hasNodeMetric()) {
            retValue.add(new NodeMetricRepo(metric.getNodeMetric()));
        }
        if (metric.hasTaskMetric()) {
            retValue.add(new TaskMetricRepo(metric.getTaskMetric()));
        }
        if (metric.hasTAttemptMetric()) {
            retValue.add(new TaskAttemptMetricRepo(metric.getTAttemptMetric()));
        }
        return retValue;
    }
}

