/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.filemonitor;

import com.mapr.baseutils.filemonitor.FileSystemListener;
import com.mapr.baseutils.filemonitor.FileSystemListenerBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMonitor {
    private List<FileSystemListener> listeners = new ArrayList<FileSystemListener>();
    public static final long TIMER_DELAY = 30000L;
    private static FileSystemMonitor s_instance = new FileSystemMonitor();
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMonitor.class);

    private FileSystemMonitor() {
        Timer timer = new Timer();
        FileSystemMonitorNotifier ttask = new FileSystemMonitorNotifier();
        timer.scheduleAtFixedRate((TimerTask)ttask, new Date(), 30000L);
    }

    public static FileSystemMonitor getInstance() {
        return s_instance;
    }

    public void addListener(FileSystemListener fsListener) {
        if (fsListener != null) {
            this.listeners.add(fsListener);
        }
    }

    public void removeListener(FileSystemListener fsListener) {
        if (fsListener != null) {
            this.listeners.remove(fsListener);
        }
    }

    private class FileSystemMonitorNotifier
    extends TimerTask {
        private FileSystemMonitorNotifier() {
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got Into Run. Number of listeners: " + FileSystemMonitor.this.listeners.size());
            }
            try {
                for (FileSystemListener listener : FileSystemMonitor.this.listeners) {
                    for (FileSystemListenerBase.FileTime fileTime : listener.getFiles().values()) {
                        long currentFileTime;
                        File file = fileTime.getFile();
                        long lastUpdatedTime = fileTime.getLastUpdateTime();
                        if (file == null || !file.exists() || (currentFileTime = file.lastModified()) <= lastUpdatedTime) continue;
                        fileTime.setLastUpdateTime(currentFileTime);
                        if (LOG.isDebugEnabled()) {
                            try {
                                LOG.debug("Invoke FileChanged on file: " + file.getCanonicalPath());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        listener.fileChanged(file);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Exception while processing fileListeners", t);
            }
        }
    }
}

